/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.web.source.ExporterProperties;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpSupplier
implements Supplier<Flux<?>> {
    private static Log logger = LogFactory.getLog(HttpSupplier.class);
    private WebClient client;
    private ExporterProperties props;

    public HttpSupplier(WebClient client, ExporterProperties props) {
        this.client = client;
        this.props = props;
    }

    @Override
    public Flux<?> get() {
        return this.get(this.client);
    }

    private Flux<?> get(WebClient client) {
        Flux result = client.get().uri(this.props.getSource().getUrl(), new Object[0]).exchange().flatMap(this::transform).repeat();
        if (this.props.isDebug()) {
            result = result.log();
        }
        return result.onErrorResume(TerminateException.class, error -> Mono.empty());
    }

    private Mono<?> transform(ClientResponse response) {
        HttpStatus status = response.statusCode();
        if (!status.is2xxSuccessful()) {
            if (this.props.isDebug()) {
                logger.info((Object)("Delaying supplier based on status=" + response.statusCode()));
            }
            return Mono.delay((Duration)Duration.ofSeconds(1L));
        }
        return response.bodyToMono(this.props.getSource().getType()).map(value -> this.message(response, value));
    }

    private Object message(ClientResponse response, Object payload) {
        if (!this.props.getSource().isIncludeHeaders()) {
            return payload;
        }
        return MessageBuilder.withPayload((Object)payload).copyHeaders((Map)HeaderUtils.fromHttp(HeaderUtils.sanitize(response.headers().asHttpHeaders()))).build();
    }

    private static class TerminateException
    extends RuntimeException {
        TerminateException() {
            super("Planned termination");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

