/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.mvc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.web.RequestProcessor;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import reactor.core.publisher.Mono;

@Component
public class FunctionController {
    private RequestProcessor processor;

    public FunctionController(RequestProcessor processor) {
        this.processor = processor;
    }

    @PostMapping(path={"/**"}, consumes={"application/x-www-form-urlencoded", "multipart/form-data"})
    @ResponseBody
    public Mono<ResponseEntity<?>> form(WebRequest request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.post(wrapper, null, false);
    }

    @PostMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> post(WebRequest request, @RequestBody(required=false) String body) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.post(wrapper, body, false);
    }

    @PostMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<Publisher<?>>> postStream(WebRequest request, @RequestBody(required=false) String body) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.post(wrapper, body, true).map(response -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(response.getHeaders())).body((Object)((Publisher)response.getBody())));
    }

    @GetMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> get(WebRequest request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.get(wrapper);
    }

    @GetMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<Publisher<?>>> getStream(WebRequest request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.stream(wrapper).map(response -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(response.getHeaders())).body((Object)((Publisher)response.getBody())));
    }

    private RequestProcessor.FunctionWrapper wrapper(WebRequest request) {
        Function function = (Function)request.getAttribute(WebRequestConstants.FUNCTION, 0);
        Consumer consumer = (Consumer)request.getAttribute(WebRequestConstants.CONSUMER, 0);
        Supplier supplier = (Supplier)request.getAttribute(WebRequestConstants.SUPPLIER, 0);
        RequestProcessor.FunctionWrapper wrapper = RequestProcessor.wrapper(function, consumer, supplier);
        for (String key : request.getParameterMap().keySet()) {
            wrapper.params().addAll((Object)key, Arrays.asList(request.getParameterValues(key)));
        }
        Iterator keys = request.getHeaderNames();
        while (keys.hasNext()) {
            String key;
            key = (String)keys.next();
            wrapper.headers().addAll(key, Arrays.asList(request.getHeaderValues(key)));
        }
        String argument = (String)request.getAttribute(WebRequestConstants.ARGUMENT, 0);
        if (argument != null) {
            wrapper.argument(argument);
        }
        return wrapper;
    }
}

