/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.cloud.function.web.source.RequestBuilder;
import org.springframework.cloud.function.web.source.SupplierProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class SupplierExporter
implements SmartLifecycle {
    private final FunctionCatalog catalog;
    private final WebClient client;
    private final DestinationResolver destinationResolver;
    private final RequestBuilder requestBuilder;
    private final String supplier;
    private volatile boolean running;
    private volatile boolean ok = true;
    private boolean autoStartup = true;
    private boolean debug = true;
    private volatile Disposable subscription;

    public SupplierExporter(RequestBuilder requestBuilder, DestinationResolver destinationResolver, FunctionCatalog catalog, WebClient client, SupplierProperties props) {
        this.requestBuilder = requestBuilder;
        this.destinationResolver = destinationResolver;
        this.catalog = catalog;
        this.client = client;
        this.debug = props.isDebug();
        this.autoStartup = props.isAutoStartup();
        this.supplier = props.getName();
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.ok = true;
        Flux streams = Flux.empty();
        Set names = this.supplier == null ? this.catalog.getNames(Supplier.class) : Collections.singleton(this.supplier);
        for (String name : names) {
            Supplier supplier = (Supplier)this.catalog.lookup(Supplier.class, name);
            streams = streams.mergeWith(this.forward(supplier, name));
        }
        this.subscription = streams.doOnError(error -> {
            this.ok = false;
            if (!this.debug) {
                error.printStackTrace();
            }
        }).doOnTerminate(() -> {
            this.running = false;
        }).doOnNext(value -> {
            if (this.subscription != null && !this.running) {
                this.subscription.dispose();
            }
        }).subscribe();
    }

    private Flux<ClientResponse> forward(Supplier<Flux<Object>> supplier, String name) {
        return supplier.get().publishOn(Schedulers.parallel()).flatMap(value -> {
            String destination = this.destinationResolver.destination(supplier, name, value);
            return this.post(this.uri(destination), destination, value);
        });
    }

    private Mono<ClientResponse> post(URI uri, String destination, Object value) {
        Mono result = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri(uri)).headers(headers -> this.headers((HttpHeaders)headers, destination, value))).body(BodyInserters.fromObject((Object)value)).exchange();
        if (this.debug) {
            result = result.log();
        }
        return result;
    }

    private void headers(HttpHeaders headers, String destination, Object value) {
        headers.putAll((Map)this.requestBuilder.headers(destination, value));
    }

    private URI uri(String destination) {
        return this.requestBuilder.uri(destination);
    }

    public boolean isOk() {
        return this.ok;
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

