/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.flux.FunctionController;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
public class FunctionHandlerMapping
extends RequestMappingHandlerMapping
implements InitializingBean {
    private final FunctionCatalog functions;
    private final FunctionController controller;
    @Value(value="${spring.cloud.function.web.path:}")
    private String prefix = "";

    @Autowired
    public FunctionHandlerMapping(FunctionCatalog catalog, FunctionController controller) {
        this.functions = catalog;
        this.logger.info((Object)("FunctionCatalog: " + catalog));
        this.setOrder(super.getOrder() - 5);
        this.controller = controller;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.detectHandlerMethods(this.controller);
        while (this.prefix.endsWith("/")) {
            this.prefix = this.prefix.substring(0, this.prefix.length() - 1);
        }
    }

    protected void initHandlerMethods() {
    }

    public Mono<HandlerMethod> getHandlerInternal(ServerWebExchange request) {
        Object function;
        String path = request.getRequest().getPath().pathWithinApplication().value();
        if (StringUtils.hasText((String)this.prefix) && !path.startsWith(this.prefix)) {
            return Mono.empty();
        }
        Mono handler = super.getHandlerInternal(request);
        if (path == null) {
            return handler;
        }
        if (path.startsWith(this.prefix)) {
            path = path.substring(this.prefix.length());
        }
        if ((function = this.findFunctionForGet(request, path)) == null) {
            function = this.findFunctionForPost(request, path);
        }
        if (function != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found function for POST: " + path));
            }
            request.getAttributes().put(WebRequestConstants.HANDLER, function);
        }
        Object actual = function;
        return handler.filter(method -> actual != null);
    }

    private Object findFunctionForPost(ServerWebExchange request, String path) {
        if (!request.getRequest().getMethod().equals((Object)HttpMethod.POST)) {
            return null;
        }
        Consumer consumer = (Consumer)this.functions.lookup(Consumer.class, path = path.startsWith("/") ? path.substring(1) : path);
        if (consumer != null) {
            request.getAttributes().put(WebRequestConstants.CONSUMER, consumer);
            return consumer;
        }
        Function function = (Function)this.functions.lookup(Function.class, path);
        if (function != null) {
            request.getAttributes().put(WebRequestConstants.FUNCTION, function);
            return function;
        }
        return null;
    }

    private Object findFunctionForGet(ServerWebExchange request, String path) {
        if (!request.getRequest().getMethod().equals((Object)HttpMethod.GET)) {
            return null;
        }
        path = path.startsWith("/") ? path.substring(1) : path;
        Object functionForGet = null;
        Supplier supplier = (Supplier)this.functions.lookup(Supplier.class, path);
        if (supplier != null) {
            request.getAttributes().put(WebRequestConstants.SUPPLIER, supplier);
            functionForGet = supplier;
        } else {
            StringBuilder builder = new StringBuilder();
            String name = path;
            String[] splitPath = path.split("/");
            Function function = null;
            for (int i = 0; i < splitPath.length || function != null; ++i) {
                String element = splitPath[i];
                if (builder.length() > 0) {
                    builder.append("/");
                }
                builder.append(element);
                name = builder.toString();
                function = (Function)this.functions.lookup(Function.class, name);
                if (function == null) continue;
                request.getAttributes().put(WebRequestConstants.FUNCTION, function);
                String value = path.length() > name.length() ? path.substring(name.length() + 1) : null;
                request.getAttributes().put(WebRequestConstants.ARGUMENT, value);
                functionForGet = function;
            }
        }
        return functionForGet;
    }
}

