/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.function.serverless.web.ServerlessHttpServletRequest;
import org.springframework.cloud.function.serverless.web.ServerlessHttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.util.WebUtils;

public class ServerlessAsyncContext
implements AsyncContext {
    private final HttpServletRequest request;
    @Nullable
    private final HttpServletResponse response;
    private final List<AsyncListener> listeners = new ArrayList<AsyncListener>();
    @Nullable
    private String dispatchedPath;
    private long timeout = 10000L;
    private final List<Runnable> dispatchHandlers = new ArrayList<Runnable>();
    private final ReentrantLock globalLock = new ReentrantLock();

    public ServerlessAsyncContext(ServletRequest request, @Nullable ServletResponse response) {
        this.request = (HttpServletRequest)request;
        this.response = (HttpServletResponse)response;
    }

    public void addDispatchHandler(Runnable handler) {
        Assert.notNull((Object)handler, (String)"Dispatch handler must not be null");
        try {
            this.globalLock.lock();
            if (this.dispatchedPath == null) {
                this.dispatchHandlers.add(handler);
            } else {
                handler.run();
            }
        }
        finally {
            this.globalLock.unlock();
        }
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    @Nullable
    public ServletResponse getResponse() {
        return this.response;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.request instanceof ServerlessHttpServletRequest && this.response instanceof ServerlessHttpServletResponse;
    }

    public void dispatch() {
        this.dispatch(this.request.getRequestURI());
    }

    public void dispatch(String path) {
        this.dispatch(null, path);
    }

    public void dispatch(@Nullable ServletContext context, String path) {
        try {
            this.globalLock.lock();
            this.dispatchedPath = path;
            this.dispatchHandlers.forEach(Runnable::run);
        }
        finally {
            this.globalLock.unlock();
        }
    }

    @Nullable
    public String getDispatchedPath() {
        return this.dispatchedPath;
    }

    public void complete() {
        ServerlessHttpServletRequest mockRequest = (ServerlessHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)this.request, ServerlessHttpServletRequest.class);
        if (mockRequest != null) {
            mockRequest.setAsyncStarted(false);
        }
        for (AsyncListener listener : this.listeners) {
            try {
                listener.onComplete(new AsyncEvent((AsyncContext)this, (ServletRequest)this.request, (ServletResponse)this.response));
            }
            catch (IOException ex) {
                throw new IllegalStateException("AsyncListener failure", ex);
            }
        }
    }

    public void start(Runnable runnable) {
        runnable.run();
    }

    public void addListener(AsyncListener listener) {
        this.listeners.add(listener);
    }

    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        this.listeners.add(listener);
    }

    public List<AsyncListener> getListeners() {
        return this.listeners;
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)((AsyncListener)BeanUtils.instantiateClass(clazz));
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

