/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.HashMap;
import org.springframework.cloud.function.grpc.AbstractGrpcMessageConverter;
import org.springframework.cloud.function.grpc.GrpcSpringMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class GrpcSpringMessageConverter
extends AbstractGrpcMessageConverter<GrpcSpringMessage> {
    @Override
    protected Message<byte[]> doToSpringMessage(GrpcSpringMessage grpcMessage) {
        return MessageBuilder.withPayload((Object)grpcMessage.getPayload().toByteArray()).copyHeaders(grpcMessage.getHeadersMap()).build();
    }

    @Override
    protected GrpcSpringMessage doFromSpringMessage(Message<byte[]> springMessage) {
        HashMap<String, String> stringHeaders = new HashMap<String, String>();
        springMessage.getHeaders().forEach((k, v) -> stringHeaders.put((String)k, v.toString()));
        return GrpcSpringMessage.newBuilder().setPayload(ByteString.copyFrom((byte[])((byte[])springMessage.getPayload()))).putAllHeaders(stringHeaders).build();
    }

    @Override
    protected boolean supports(Class<? extends GeneratedMessageV3> grpcClass) {
        return grpcClass.isAssignableFrom(GrpcSpringMessage.class);
    }
}

