/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc.ce;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import io.cloudevents.v1.proto.CloudEvent;
import java.util.Map;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.grpc.AbstractGrpcMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class CloudEventMessageConverter
extends AbstractGrpcMessageConverter<CloudEvent> {
    protected Message<byte[]> doToSpringMessage(CloudEvent cloudEvent) {
        MessageBuilder builder = MessageBuilder.withPayload((Object)cloudEvent.getTextData());
        builder.setHeader(CloudEventMessageUtils.TYPE, (Object)cloudEvent.getType());
        builder.setHeader(CloudEventMessageUtils.SOURCE, (Object)cloudEvent.getSource());
        builder.setHeader(CloudEventMessageUtils.ID, (Object)cloudEvent.getId());
        builder.setHeader(CloudEventMessageUtils.SPECVERSION, (Object)cloudEvent.getId());
        for (Map.Entry<String, CloudEvent.CloudEventAttributeValue> attributeEntry : cloudEvent.getAttributesMap().entrySet()) {
            CloudEvent.CloudEventAttributeValue.AttrCase attrCase = attributeEntry.getValue().getAttrCase();
            if (attrCase.equals((Object)CloudEvent.CloudEventAttributeValue.AttrCase.CE_BOOLEAN)) {
                builder.setHeader(attributeEntry.getKey(), (Object)attributeEntry.getValue().getCeBoolean());
                continue;
            }
            if (attrCase.equals((Object)CloudEvent.CloudEventAttributeValue.AttrCase.CE_BYTES)) {
                builder.setHeader(attributeEntry.getKey(), (Object)attributeEntry.getValue().getCeBytes());
                continue;
            }
            if (attrCase.equals((Object)CloudEvent.CloudEventAttributeValue.AttrCase.CE_INTEGER)) {
                builder.setHeader(attributeEntry.getKey(), (Object)attributeEntry.getValue().getCeInteger());
                continue;
            }
            if (attrCase.equals((Object)CloudEvent.CloudEventAttributeValue.AttrCase.CE_STRING)) {
                builder.setHeader(attributeEntry.getKey(), (Object)attributeEntry.getValue().getCeString());
                continue;
            }
            if (attrCase.equals((Object)CloudEvent.CloudEventAttributeValue.AttrCase.CE_TIMESTAMP)) {
                builder.setHeader(attributeEntry.getKey(), (Object)attributeEntry.getValue().getCeTimestamp());
                continue;
            }
            if (attrCase.equals((Object)CloudEvent.CloudEventAttributeValue.AttrCase.CE_URI)) {
                builder.setHeader(attributeEntry.getKey(), (Object)attributeEntry.getValue().getCeUri());
                continue;
            }
            if (attrCase.equals((Object)CloudEvent.CloudEventAttributeValue.AttrCase.CE_URI_REF)) {
                builder.setHeader(attributeEntry.getKey(), (Object)attributeEntry.getValue().getCeUriRef());
                continue;
            }
            throw new IllegalStateException("Unknown type for attribute " + attributeEntry.getKey());
        }
        return builder.build();
    }

    protected CloudEvent doFromSpringMessage(Message<byte[]> springMessage) {
        CloudEvent.Builder builder = CloudEvent.newBuilder().setTextDataBytes(ByteString.copyFrom((byte[])((byte[])springMessage.getPayload()))).setType(CloudEventMessageUtils.getType(springMessage)).setSource(CloudEventMessageUtils.getSource(springMessage).toString()).setId(CloudEventMessageUtils.getId(springMessage)).setSpecVersion(CloudEventMessageUtils.getSpecVersion(springMessage));
        for (Map.Entry entry : springMessage.getHeaders().entrySet()) {
            builder.putAttributes((String)entry.getKey(), CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(entry.getValue().toString()).build());
        }
        return builder.build();
    }

    protected boolean supports(Class<? extends GeneratedMessageV3> grpcClass) {
        return grpcClass.isAssignableFrom(CloudEvent.class);
    }
}

