/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.util.HashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.resource.maven.MavenResourceLoader;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.function.deployer.FunctionCreatorConfiguration;
import org.springframework.cloud.function.deployer.FunctionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(prefix="function.deployer", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
@Import(value={FunctionCreatorConfiguration.class})
public class FunctionDeployerConfiguration {
    @Bean
    @ConfigurationProperties(value="maven")
    public MavenProperties mavenProperties() {
        return new MavenProperties();
    }

    @Bean
    @ConfigurationProperties(value="function")
    public FunctionProperties functionProperties() {
        return new FunctionProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={DelegatingResourceLoader.class})
    public DelegatingResourceLoader delegatingResourceLoader(MavenProperties mavenProperties) {
        HashMap<String, MavenResourceLoader> loaders = new HashMap<String, MavenResourceLoader>();
        loaders.put(MavenResource.URI_SCHEME, new MavenResourceLoader(mavenProperties));
        return new DelegatingResourceLoader(loaders);
    }
}

