/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinUtils {
    private KotlinUtils() {
    }

    public static boolean isKotlinType(Object object, Type functionType) {
        if (KotlinDetector.isKotlinPresent()) {
            boolean isKotlinObject;
            boolean bl = isKotlinObject = KotlinDetector.isKotlinType(object.getClass()) || object instanceof Function0 || object instanceof Function1;
            if (isKotlinObject) {
                return true;
            }
            if (functionType instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)functionType).getActualTypeArguments();
                return KotlinUtils.hasFlowType(types);
            }
            return false;
        }
        return false;
    }

    public static ResolvableType getSuspendingFunctionArgType(Type type) {
        return ResolvableType.forType((Type)KotlinUtils.getFlowTypeArguments(type));
    }

    public static ResolvableType getSuspendingFunctionReturnType(Type type) {
        Type lower = KotlinUtils.getContinuationTypeArguments(type);
        return ResolvableType.forType((Type)KotlinUtils.getFlowTypeArguments(lower));
    }

    public static Type getFlowTypeArguments(Type type) {
        if (!KotlinUtils.isFlowType(type)) {
            return type;
        }
        ParameterizedType parameterizedLowerType = (ParameterizedType)type;
        if (parameterizedLowerType.getActualTypeArguments().length == 0) {
            return parameterizedLowerType;
        }
        Type actualTypeArgument = parameterizedLowerType.getActualTypeArguments()[0];
        if (actualTypeArgument instanceof WildcardType) {
            WildcardType wildcardTypeLower = (WildcardType)parameterizedLowerType.getActualTypeArguments()[0];
            return wildcardTypeLower.getUpperBounds()[0];
        }
        return actualTypeArgument;
    }

    public static boolean hasFlowType(Type[] types) {
        for (Type type : types) {
            if (!KotlinUtils.isFlowType(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlowType(Type type) {
        return type.getTypeName().startsWith(Flow.class.getName());
    }

    public static boolean isContinuationType(Type type) {
        return type.getTypeName().startsWith(Continuation.class.getName());
    }

    public static boolean isUnitType(Type type) {
        return KotlinUtils.isTypeRepresentedByClass(type, Unit.class);
    }

    public static boolean isVoidType(Type type) {
        return KotlinUtils.isTypeRepresentedByClass(type, Void.class);
    }

    public static boolean isContinuationUnitType(Type type) {
        return KotlinUtils.isContinuationType(type) && type.getTypeName().contains(Unit.class.getName());
    }

    public static boolean isContinuationFlowType(Type type) {
        return KotlinUtils.isContinuationType(type) && type.getTypeName().contains(Flow.class.getName());
    }

    public static Type getContinuationTypeArguments(Type type) {
        if (!KotlinUtils.isContinuationType(type)) {
            return type;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type typeArg = parameterizedType.getActualTypeArguments()[0];
        if (typeArg instanceof WildcardType) {
            return ((WildcardType)typeArg).getLowerBounds()[0];
        }
        if (typeArg instanceof ParameterizedType) {
            return typeArg;
        }
        return typeArg;
    }

    public static <T> Flow<T> convertToFlow(Flux<T> arg0) {
        return ReactiveFlowKt.asFlow(arg0);
    }

    public static <T> Flux<T> convertToFlux(Flow<T> arg0) {
        return ReactorFlowKt.asFlux(arg0);
    }

    public static boolean isValidKotlinConsumer(Type functionType, Type[] type) {
        return KotlinUtils.isTypeRepresentedByClass(functionType, Consumer.class) || KotlinUtils.isTypeRepresentedByClass(functionType, Function1.class) && type.length == 2 && !KotlinUtils.isContinuationType(type[0]) && (KotlinUtils.isUnitType(type[1]) || KotlinUtils.isVoidType(type[1]));
    }

    public static boolean isValidKotlinSuspendConsumer(Type functionType, Type[] type) {
        return KotlinUtils.isTypeRepresentedByClass(functionType, Function2.class) && type.length == 3 && KotlinUtils.isContinuationUnitType(type[1]);
    }

    public static boolean isValidKotlinFunction(Type functionType, Type[] type) {
        return (KotlinUtils.isTypeRepresentedByClass(functionType, Function1.class) || KotlinUtils.isTypeRepresentedByClass(functionType, Function.class)) && type.length == 2 && !KotlinUtils.isContinuationType(type[0]) && !KotlinUtils.isUnitType(type[1]);
    }

    public static boolean isValidKotlinSuspendFunction(Type functionType, Type[] type) {
        return KotlinUtils.isTypeRepresentedByClass(functionType, Function2.class) && type.length == 3 && KotlinUtils.isContinuationType(type[1]) && !KotlinUtils.isContinuationUnitType(type[1]);
    }

    public static boolean isValidKotlinSupplier(Type functionType) {
        return KotlinUtils.isTypeRepresentedByClass(functionType, Function0.class) || KotlinUtils.isTypeRepresentedByClass(functionType, Supplier.class);
    }

    public static boolean isValidKotlinSuspendSupplier(Type functionType, Type[] type) {
        return KotlinUtils.isTypeRepresentedByClass(functionType, Function1.class) && type.length == 2 && KotlinUtils.isContinuationType(type[0]);
    }

    public static boolean isTypeRepresentedByClass(Type type, Class<?> clazz) {
        return type.getTypeName().contains(clazz.getName());
    }
}

