/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import org.springframework.cloud.function.context.config.CoroutinesUtils;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

public final class KotlinSupplierSuspendWrapper
implements KotlinFunctionWrapper,
Supplier<Object>,
Function0<Object> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinSuspendSupplier(functionType, types);
    }

    public static KotlinSupplierSuspendWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType returnType = KotlinUtils.getSuspendingFunctionReturnType(propsTypes[0]);
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{returnType})});
        return new KotlinSupplierSuspendWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinSupplierSuspendWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.name = functionName;
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.type = type;
    }

    public Object apply(Object input) {
        if (ObjectUtils.isEmpty((Object)input)) {
            return this.get();
        }
        return null;
    }

    @Override
    public Object get() {
        return this.invoke();
    }

    public Object invoke() {
        return CoroutinesUtils.invokeSuspendingSupplier(this.kotlinLambdaTarget);
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

