/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Function;
import kotlin.jvm.functions.Function1;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;

public final class KotlinFunctionPlainToPlainWrapper
implements KotlinFunctionWrapper,
Function<Object, Object>,
Function1<Object, Object> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinFunction(functionType, types);
    }

    public static KotlinFunctionPlainToPlainWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType type = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)propsTypes[0]), ResolvableType.forType((Type)propsTypes[1])});
        return new KotlinFunctionPlainToPlainWrapper(kotlinLambdaTarget, type, functionName);
    }

    public KotlinFunctionPlainToPlainWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.name = functionName;
        this.type = type;
    }

    public Object invoke(Object arg0) {
        if (this.kotlinLambdaTarget instanceof Function1) {
            return ((Function1)this.kotlinLambdaTarget).invoke(arg0);
        }
        if (this.kotlinLambdaTarget instanceof Function) {
            return ((Function)this.kotlinLambdaTarget).apply(arg0);
        }
        throw new IllegalArgumentException("Unsupported target type: " + this.kotlinLambdaTarget.getClass());
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object apply(Object input) {
        return this.invoke(input);
    }
}

