/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.wrapper;

import java.lang.reflect.Type;
import java.util.function.Function;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import org.springframework.cloud.function.context.wrapper.KotlinFunctionWrapper;
import org.springframework.cloud.function.utils.KotlinUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public final class KotlinFunctionFlowToPlainWrapper
implements KotlinFunctionWrapper,
Function<Flux<Object>, Object>,
Function1<Flux<Object>, Object> {
    private final Object kotlinLambdaTarget;
    private final String name;
    private final ResolvableType type;

    public static Boolean isValid(Type functionType, Type[] types) {
        return KotlinUtils.isValidKotlinFunction(functionType, types) && types.length == 2 && KotlinUtils.isFlowType(types[0]) && !KotlinUtils.isFlowType(types[1]);
    }

    public static KotlinFunctionFlowToPlainWrapper asRegistrationFunction(String functionName, Object kotlinLambdaTarget, Type[] propsTypes) {
        ResolvableType props = ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)propsTypes[0])});
        ResolvableType result = ResolvableType.forType((Type)propsTypes[1]);
        ResolvableType functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{props, result});
        return new KotlinFunctionFlowToPlainWrapper(kotlinLambdaTarget, functionType, functionName);
    }

    public KotlinFunctionFlowToPlainWrapper(Object kotlinLambdaTarget, ResolvableType type, String functionName) {
        this.kotlinLambdaTarget = kotlinLambdaTarget;
        this.name = functionName;
        this.type = type;
    }

    public Object invoke(Flux<Object> arg0) {
        Flow<Object> flow = KotlinUtils.convertToFlow(arg0);
        if (this.kotlinLambdaTarget instanceof Function) {
            Function target = (Function)this.kotlinLambdaTarget;
            return target.apply(flow);
        }
        if (this.kotlinLambdaTarget instanceof Function1) {
            Function1 target = (Function1)this.kotlinLambdaTarget;
            return target.invoke(flow);
        }
        throw new IllegalArgumentException("Unsupported target type: " + this.kotlinLambdaTarget.getClass());
    }

    @Override
    public ResolvableType getResolvableType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object apply(Flux<Object> input) {
        return this.invoke(input);
    }
}

