/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.cloudevent.CloudEventAttributes;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionAroundWrapper;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public class SimpleFunctionRegistry
implements FunctionRegistry,
FunctionInspector {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final Field headersField;
    private final Set<FunctionRegistration<?>> functionRegistrations = new HashSet();
    private final Map<String, FunctionInvocationWrapper> wrappedFunctionDefinitions = new HashMap<String, FunctionInvocationWrapper>();
    private final ConversionService conversionService;
    private final CompositeMessageConverter messageConverter;
    private final JsonMapper jsonMapper;
    @Autowired(required=false)
    private FunctionAroundWrapper functionAroundWrapper;

    public SimpleFunctionRegistry(ConversionService conversionService, CompositeMessageConverter messageConverter, JsonMapper jsonMapper) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        Assert.notNull((Object)jsonMapper, (String)"'jsonMapper' must not be null");
        this.conversionService = conversionService;
        this.jsonMapper = jsonMapper;
        this.messageConverter = messageConverter;
        this.headersField = ReflectionUtils.findField(MessageHeaders.class, (String)"headers");
        this.headersField.setAccessible(true);
    }

    @Override
    public <T> T lookup(Class<?> type, String functionDefinition, String ... expectedOutputMimeTypes) {
        functionDefinition = this.normalizeFunctionDefinition(functionDefinition);
        FunctionInvocationWrapper function = (FunctionInvocationWrapper)this.doLookup(type, functionDefinition, expectedOutputMimeTypes);
        if (this.logger.isInfoEnabled()) {
            if (function != null) {
                this.logger.info((Object)("Located function: " + function));
            } else {
                this.logger.info((Object)("Failed to locate function: " + functionDefinition));
            }
        }
        return (T)function;
    }

    @Override
    public FunctionRegistration<?> getRegistration(Object function) {
        throw new UnsupportedOperationException("FunctionInspector is deprecated. There is no need to access FunctionRegistration directly since you can interogate the actual looked-up function (see FunctionInvocationWrapper.");
    }

    @Override
    public <T> void register(FunctionRegistration<T> registration) {
        Assert.notNull(registration, (String)"'registration' must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering function " + registration.getNames()));
        }
        this.functionRegistrations.add(registration);
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        return this.functionRegistrations.stream().flatMap(fr -> fr.getNames().stream()).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.functionRegistrations.size();
    }

    protected boolean containsFunction(String functionName) {
        return this.functionRegistrations.stream().anyMatch(reg -> reg.getNames().contains(functionName));
    }

    <T> T doLookup(Class<?> type, String functionDefinition, String[] expectedOutputMimeTypes) {
        FunctionInvocationWrapper function = this.wrappedFunctionDefinitions.get(functionDefinition);
        if (function == null) {
            function = this.compose(type, functionDefinition);
        }
        if (function != null && !ObjectUtils.isEmpty((Object[])expectedOutputMimeTypes)) {
            FunctionInvocationWrapper.access$002(function, expectedOutputMimeTypes);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Function '" + functionDefinition + "' is not found in cache"));
        }
        function = this.wrapInAroundAviceIfNecessary(function);
        return (T)function;
    }

    String normalizeFunctionDefinition(String functionDefinition) {
        List eligibleFunction;
        String string = functionDefinition = StringUtils.hasText((String)functionDefinition) ? functionDefinition.replaceAll(",", "|") : System.getProperty("spring.cloud.function.definition", "");
        if (!(this.getNames(null).contains(functionDefinition) || (eligibleFunction = this.getNames(null).stream().filter(name -> !"functionRouter".equals(name)).collect(Collectors.toList())).size() != 1 || ((String)eligibleFunction.get(0)).equals(functionDefinition) || functionDefinition.contains("|"))) {
            functionDefinition = (String)eligibleFunction.get(0);
        }
        return functionDefinition;
    }

    private FunctionInvocationWrapper wrapInAroundAviceIfNecessary(final FunctionInvocationWrapper function) {
        FunctionInvocationWrapper wrappedFunction = function;
        if (function != null && this.functionAroundWrapper != null) {
            wrappedFunction = new FunctionInvocationWrapper(function){

                @Override
                Object doApply(Object input) {
                    SimpleFunctionRegistry.this.logger.info((Object)"Executing around advise(s)");
                    return SimpleFunctionRegistry.this.functionAroundWrapper.apply(input, function);
                }
            };
        }
        return wrappedFunction;
    }

    private FunctionInvocationWrapper findFunctionInFunctionRegistrations(String functionName) {
        FunctionRegistration functionRegistration = this.functionRegistrations.stream().filter(fr -> fr.getNames().contains(functionName)).findFirst().orElseGet(() -> null);
        return functionRegistration != null ? this.invocationWrapperInstance(functionName, functionRegistration.getTarget(), functionRegistration.getType().getType()) : null;
    }

    private FunctionInvocationWrapper compose(Class<?> type, String functionDefinition) {
        String[] functionNames = StringUtils.delimitedListToStringArray((String)functionDefinition.replaceAll(",", "|").trim(), (String)"|");
        FunctionInvocationWrapper composedFunction = null;
        for (String functionName : functionNames) {
            FunctionInvocationWrapper function = this.findFunctionInFunctionRegistrations(functionName);
            if (function == null) {
                return null;
            }
            if (composedFunction == null) {
                composedFunction = function;
            } else {
                FunctionInvocationWrapper andThenFunction = this.invocationWrapperInstance(functionName, function.getTarget(), function.inputType, function.outputType);
                composedFunction = (FunctionInvocationWrapper)composedFunction.andThen(andThenFunction);
            }
            this.wrappedFunctionDefinitions.put(composedFunction.functionDefinition, composedFunction);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Composed function " + composedFunction));
        }
        return composedFunction;
    }

    private FunctionInvocationWrapper invocationWrapperInstance(String functionDefinition, Object target, Type inputType, Type outputType) {
        return new FunctionInvocationWrapper(functionDefinition, target, inputType, outputType);
    }

    private FunctionInvocationWrapper invocationWrapperInstance(String functionDefinition, Object target, Type functionType) {
        return this.invocationWrapperInstance(functionDefinition, target, FunctionTypeUtils.isSupplier(functionType) ? null : FunctionTypeUtils.getInputType(functionType), FunctionTypeUtils.getOutputType(functionType));
    }

    private static final class OriginalMessageHolder {
        private final Object value;
        private final Message<?> originalMessage;

        private OriginalMessageHolder(Object value, Message<?> originalMessage) {
            this.value = value;
            this.originalMessage = originalMessage;
        }

        public Object getValue() {
            return this.value;
        }

        public Message<?> getOriginalMessage() {
            return this.originalMessage;
        }
    }

    public class FunctionInvocationWrapper
    implements Function<Object, Object>,
    Consumer<Object>,
    Supplier<Object>,
    Runnable {
        private final Object target;
        private Type inputType;
        private final Type outputType;
        private final String functionDefinition;
        private boolean composed;
        private boolean message;
        private String[] expectedOutputContentType;
        private boolean skipInputConversion;
        private boolean skipOutputConversion;
        private Function<Object, Message> enhancer;
        private BiFunction<Message<?>, Object, Message<?>> outputMessageHeaderEnricher;

        void setOutputMessageHeaderEnricher(BiFunction<Message<?>, Object, Message<?>> outputMessageHeaderEnricher) {
            this.outputMessageHeaderEnricher = outputMessageHeaderEnricher;
        }

        FunctionInvocationWrapper(FunctionInvocationWrapper function) {
            this.target = function.target;
            this.inputType = function.inputType;
            this.outputType = function.outputType;
            this.functionDefinition = function.functionDefinition;
            this.message = this.inputType != null && FunctionTypeUtils.isMessage(this.inputType);
        }

        FunctionInvocationWrapper(String functionDefinition, Object target, Type inputType, Type outputType) {
            this.target = target;
            this.inputType = this.normalizeType(inputType);
            this.outputType = this.normalizeType(outputType);
            this.functionDefinition = functionDefinition;
            this.message = this.inputType != null && FunctionTypeUtils.isMessage(this.inputType);
        }

        public void setSkipInputConversion(boolean skipInputConversion) {
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled() && skipInputConversion) {
                SimpleFunctionRegistry.this.logger.debug((Object)"'skipInputConversion' was explicitely set to true. No input conversion will be attempted");
            }
            this.skipInputConversion = skipInputConversion;
        }

        public void setSkipOutputConversion(boolean skipOutputConversion) {
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled() && skipOutputConversion) {
                SimpleFunctionRegistry.this.logger.debug((Object)"'skipOutputConversion' was explicitely set to true. No output conversion will be attempted");
            }
            this.skipOutputConversion = skipOutputConversion;
        }

        public Object getTarget() {
            return this.target;
        }

        public Type getOutputType() {
            return this.outputType;
        }

        public Type getInputType() {
            return this.inputType;
        }

        public Type getItemType(Type type) {
            if (FunctionTypeUtils.isPublisher(type) || FunctionTypeUtils.isMessage(type) || FunctionTypeUtils.isTypeCollection(type)) {
                type = FunctionTypeUtils.getGenericType(type);
            }
            return type;
        }

        @Deprecated
        public Type getFunctionType() {
            if (this.isFunction()) {
                ResolvableType rItype = ResolvableType.forType((Type)this.inputType);
                ResolvableType rOtype = ResolvableType.forType((Type)this.outputType);
                return ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{rItype, rOtype}).getType();
            }
            if (this.isConsumer()) {
                ResolvableType rItype = ResolvableType.forType((Type)this.inputType);
                return ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{rItype}).getType();
            }
            ResolvableType rOtype = ResolvableType.forType((Type)this.outputType);
            return ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{rOtype}).getType();
        }

        public Class<?> getRawOutputType() {
            return this.outputType == null ? null : FunctionTypeUtils.getRawType(this.outputType);
        }

        public Class<?> getRawInputType() {
            return this.inputType == null ? null : FunctionTypeUtils.getRawType(this.inputType);
        }

        @Override
        public Object apply(Object input) {
            Object result;
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled() && !(input instanceof Publisher)) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Invoking function " + this));
            }
            if ((result = this.doApply(input)) != null && this.outputType != null) {
                result = this.convertOutputIfNecessary(result, this.outputType, this.expectedOutputContentType);
            }
            return result;
        }

        @Override
        public Object get() {
            return this.apply((Object)null);
        }

        @Override
        public void accept(Object input) {
            this.apply(input);
        }

        @Override
        public void run() {
            this.apply((Object)null);
        }

        public boolean isConsumer() {
            return this.outputType == null;
        }

        public boolean isSupplier() {
            return this.inputType == null;
        }

        public boolean isFunction() {
            return this.inputType != null && this.outputType != null;
        }

        public boolean isInputTypePublisher() {
            return this.isTypePublisher(this.inputType);
        }

        public boolean isOutputTypePublisher() {
            return this.isTypePublisher(this.outputType);
        }

        public boolean isInputTypeMessage() {
            boolean b = this.message || this.isRoutingFunction();
            return b;
        }

        public boolean isOutputTypeMessage() {
            return FunctionTypeUtils.isMessage(this.outputType);
        }

        public boolean isRoutingFunction() {
            return this.target instanceof RoutingFunction;
        }

        @Override
        public <V> Function<Object, V> andThen(Function<? super Object, ? extends V> after) {
            Type composedFunctionType;
            Assert.isTrue((boolean)(after instanceof FunctionInvocationWrapper), (String)"Composed function must be an instanceof FunctionInvocationWrapper.");
            if (FunctionTypeUtils.isMultipleArgumentType(this.inputType) || FunctionTypeUtils.isMultipleArgumentType(this.outputType) || FunctionTypeUtils.isMultipleArgumentType(((FunctionInvocationWrapper)after).inputType) || FunctionTypeUtils.isMultipleArgumentType(((FunctionInvocationWrapper)after).outputType)) {
                throw new UnsupportedOperationException("Composition of functions with multiple arguments is not supported at the moment");
            }
            Function<Object, Object> rawComposedFunction = v -> ((FunctionInvocationWrapper)after).doApply(this.doApply(v));
            FunctionInvocationWrapper afterWrapper = (FunctionInvocationWrapper)after;
            if (afterWrapper.outputType == null) {
                composedFunctionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{this.inputType == null ? null : ResolvableType.forType((Type)this.inputType)}).getType();
            } else if (this.inputType == null && afterWrapper.outputType != null) {
                ResolvableType composedOutputType = FunctionTypeUtils.isFlux(this.outputType) ? ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)afterWrapper.outputType)}) : (FunctionTypeUtils.isMono(this.outputType) ? ResolvableType.forClassWithGenerics(Mono.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)afterWrapper.outputType)}) : ResolvableType.forType((Type)afterWrapper.outputType));
                composedFunctionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{composedOutputType}).getType();
            } else {
                if (this.outputType == null) {
                    throw new IllegalArgumentException("Can NOT compose anything with Consumer");
                }
                composedFunctionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)this.inputType), ResolvableType.forType((Type)((FunctionInvocationWrapper)after).outputType)}).getType();
            }
            String composedName = this.functionDefinition + "|" + afterWrapper.functionDefinition;
            FunctionInvocationWrapper composedFunction = SimpleFunctionRegistry.this.invocationWrapperInstance(composedName, rawComposedFunction, composedFunctionType);
            composedFunction.composed = true;
            return composedFunction;
        }

        public String getFunctionDefinition() {
            return this.functionDefinition;
        }

        public String toString() {
            return this.functionDefinition + (this.isComposed() ? "" : "<" + this.inputType + ", " + this.outputType + ">");
        }

        boolean isComposed() {
            return this.composed;
        }

        Object doApply(Object input) {
            input = this.fluxifyInputIfNecessary(input);
            Object convertedInput = this.convertInputIfNecessary(input, this.inputType);
            Object result = this.isRoutingFunction() || this.isComposed() ? ((Function)this.target).apply(convertedInput) : (this.isSupplier() ? ((Supplier)this.target).get() : (this.isConsumer() ? this.invokeConsumer(convertedInput) : this.invokeFunction(convertedInput)));
            return result;
        }

        private boolean isTypePublisher(Type type) {
            return type != null && FunctionTypeUtils.isPublisher(type);
        }

        private Type normalizeType(Type type) {
            if (type != null) {
                return !(type instanceof TypeVariable) && !(type instanceof WildcardType) ? type : Object.class;
            }
            return type;
        }

        private Class<?> getRawClassFor(@Nullable Type type) {
            return type instanceof TypeVariable || type instanceof WildcardType ? Object.class : FunctionTypeUtils.getRawType(type);
        }

        private Object enrichInvocationResultIfNecessary(Object input, Object result) {
            if (result != null && !(result instanceof Publisher) && input instanceof Message) {
                if (result instanceof Message) {
                    Map headersMap = (Map)ReflectionUtils.getField((Field)SimpleFunctionRegistry.this.headersField, (Object)((Message)result).getHeaders());
                    this.sanitizeHeaders(((Message)input).getHeaders()).forEach((k, v) -> headersMap.putIfAbsent(k, v));
                } else {
                    result = this.outputMessageHeaderEnricher != null ? this.outputMessageHeaderEnricher.apply((Message)input, result) : MessageBuilder.withPayload((Object)result).copyHeaders(this.sanitizeHeaders(((Message)input).getHeaders())).build();
                }
            }
            return result;
        }

        private Map<String, Object> sanitizeHeaders(MessageHeaders headers) {
            HashMap<String, Object> sanitizedHeaders = new HashMap<String, Object>();
            headers.forEach((k, v) -> {
                if (v != null) {
                    sanitizedHeaders.put((String)k, v);
                }
            });
            return sanitizedHeaders;
        }

        private Object fluxifyInputIfNecessary(Object input) {
            if (!(input instanceof Publisher) && this.isTypePublisher(this.inputType) && !FunctionTypeUtils.isMultipleArgumentType(this.inputType)) {
                return input == null ? (FunctionTypeUtils.isMono(this.inputType) ? Mono.empty() : Flux.empty()) : (FunctionTypeUtils.isMono(this.inputType) ? Mono.just((Object)input) : Flux.just((Object)input));
            }
            return input;
        }

        private Object invokeFunction(Object convertedInput) {
            Object result;
            if (!this.isTypePublisher(this.inputType) && convertedInput instanceof Publisher) {
                result = convertedInput instanceof Mono ? Mono.from((Publisher)((Publisher)convertedInput)).map(value -> this.invokeFunctionAndEnrichResultIfNecessary(value)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex)) : Flux.from((Publisher)((Publisher)convertedInput)).map(value -> this.invokeFunctionAndEnrichResultIfNecessary(value)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex));
            } else {
                result = this.invokeFunctionAndEnrichResultIfNecessary(convertedInput);
                if (result instanceof Flux) {
                    result = ((Flux)result).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex));
                } else if (result instanceof Mono) {
                    result = ((Mono)result).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex));
                }
            }
            return result;
        }

        private Object invokeFunctionAndEnrichResultIfNecessary(Object value) {
            Object inputValue = value instanceof Flux ? ((Flux)value).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v)) : (value instanceof Mono ? ((Mono)value).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v)) : this.extractValueFromOriginalValueHolderIfNecessary(value));
            if (inputValue instanceof Message && !this.isInputTypeMessage()) {
                inputValue = ((Message)inputValue).getPayload();
            }
            Object result = ((Function)this.target).apply(inputValue);
            return value instanceof OriginalMessageHolder ? this.enrichInvocationResultIfNecessary(((OriginalMessageHolder)value).getOriginalMessage(), result) : result;
        }

        private Object invokeConsumer(Object convertedInput) {
            Mono result = null;
            if (this.isTypePublisher(this.inputType)) {
                result = convertedInput instanceof Flux ? ((Flux)convertedInput).transform(flux -> {
                    flux = Flux.from((Publisher)((Publisher)flux)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v));
                    ((Consumer)this.target).accept(flux);
                    return Mono.ignoreElements((Publisher)((Flux)flux));
                }).then() : ((Mono)convertedInput).transform(mono -> {
                    mono = Mono.from((Publisher)((Publisher)mono)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v));
                    ((Consumer)this.target).accept(mono);
                    return Mono.ignoreElements((Publisher)((Flux)mono));
                }).then();
            } else if (convertedInput instanceof Publisher) {
                result = convertedInput instanceof Mono ? Mono.from((Publisher)((Publisher)convertedInput)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v)).doOnNext((Consumer)this.target).then() : Flux.from((Publisher)((Publisher)convertedInput)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v)).doOnNext((Consumer)this.target).then();
            } else {
                ((Consumer)this.target).accept(this.extractValueFromOriginalValueHolderIfNecessary(convertedInput));
            }
            return result;
        }

        private Object extractValueFromOriginalValueHolderIfNecessary(Object input) {
            if (input instanceof OriginalMessageHolder) {
                input = ((OriginalMessageHolder)input).getValue();
            }
            return input;
        }

        private Object[] parseMultipleValueArguments(Object multipleValueArgument, int argumentCount) {
            Object[] parsedArgumentValues = new Object[argumentCount];
            if (multipleValueArgument.getClass().getName().startsWith("reactor.util.function.Tuple")) {
                for (int i = 0; i < argumentCount; ++i) {
                    Object outputArgument;
                    Expression parsed = new SpelExpressionParser().parseExpression("getT" + (i + 1) + "()");
                    parsedArgumentValues[i] = outputArgument = parsed.getValue(multipleValueArgument);
                }
                return parsedArgumentValues;
            }
            throw new UnsupportedOperationException("At the moment only Tuple-based function are supporting multiple arguments");
        }

        private boolean isInputConversionNecessary(Object input, Type type) {
            if (type == null || this.getRawClassFor(type) == Void.class || this.target instanceof RoutingFunction || this.isComposed()) {
                if (this.getRawClassFor(type) == Void.class) {
                    if (input instanceof Message && (input = ((Message)input).getPayload()) instanceof Optional) {
                        input = ((Optional)input).orElseGet(() -> null);
                    }
                    Assert.isNull((Object)input, (String)"Can't have non-null input with Void input type.");
                }
                return false;
            }
            return true;
        }

        private Object convertInputIfNecessary(Object input, Type type) {
            if (!this.isInputConversionNecessary(input, type)) {
                return input;
            }
            Object convertedInput = null;
            if (input instanceof Publisher) {
                convertedInput = this.convertInputPublisherIfNecessary((Publisher)input, type);
            } else if (FunctionTypeUtils.isMultipleArgumentType(type)) {
                Type[] inputTypes = ((ParameterizedType)type).getActualTypeArguments();
                Object[] multipleValueArguments = this.parseMultipleValueArguments(input, inputTypes.length);
                Object[] convertedInputs = new Object[inputTypes.length];
                for (int i = 0; i < multipleValueArguments.length; ++i) {
                    Object cInput;
                    convertedInputs[i] = cInput = this.convertInputIfNecessary(multipleValueArguments[i], inputTypes[i]);
                }
                convertedInput = Tuples.fromArray((Object[])convertedInputs);
            } else if (this.skipInputConversion) {
                convertedInput = this.isInputTypeMessage() ? input : new OriginalMessageHolder(((Message)input).getPayload(), (Message)input);
            } else if (input instanceof Message) {
                if (((Message)input).getPayload().getClass().getName().equals("org.springframework.kafka.support.KafkaNull") && !this.isInputTypeMessage()) {
                    return null;
                }
                convertedInput = this.convertInputMessageIfNecessary(input = CloudEventMessageUtils.toBinary((Message)input, (MessageConverter)SimpleFunctionRegistry.this.messageConverter), type);
                if (convertedInput == null) {
                    convertedInput = this.convertNonMessageInputIfNecessary(type, input.getPayload(), false);
                }
                if (convertedInput != null && !FunctionTypeUtils.isMultipleArgumentType(this.inputType)) {
                    Object object = convertedInput = !convertedInput.equals(input) ? new OriginalMessageHolder(convertedInput, input) : convertedInput;
                }
                if (convertedInput != null && SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                    SimpleFunctionRegistry.this.logger.debug((Object)("Converted Message: " + input + " to: " + convertedInput));
                }
            } else {
                convertedInput = this.convertNonMessageInputIfNecessary(type, input, JsonMapper.isJsonString(input));
                if (convertedInput != null && SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                    SimpleFunctionRegistry.this.logger.debug((Object)("Converted input: " + input + " to: " + convertedInput));
                }
            }
            if (this.isWrapConvertedInputInMessage(convertedInput)) {
                convertedInput = MessageBuilder.withPayload((Object)convertedInput).build();
            }
            Assert.notNull((Object)convertedInput, (String)("Failed to convert input: " + input + " to " + type));
            return convertedInput;
        }

        private Object convertOutputIfNecessary(Object output, Type type, String[] contentType) {
            if (this.skipOutputConversion) {
                return output;
            }
            if (output instanceof Message && !this.containsRetainMessageSignalInHeaders((Message)output) && (!FunctionTypeUtils.isMessage(type) || FunctionTypeUtils.isMessage(type) && Collection.class.isAssignableFrom(FunctionTypeUtils.getRawType(type)))) {
                output = ((Message)output).getPayload();
            }
            if (!(output instanceof Publisher) && this.enhancer != null) {
                output = this.enhancer.apply(output);
            }
            if (ObjectUtils.isEmpty((Object[])contentType) && !(output instanceof Publisher)) {
                return output;
            }
            Object convertedOutput = output;
            convertedOutput = FunctionTypeUtils.isMultipleArgumentType(type) ? this.convertMultipleOutputArgumentTypeIfNecesary(convertedOutput, type, contentType) : (output instanceof Publisher ? this.convertOutputPublisherIfNecessary((Publisher)output, type, contentType) : (output instanceof Message ? this.convertOutputMessageIfNecessary(output, ObjectUtils.isEmpty((Object[])contentType) ? null : contentType[0]) : (output instanceof Collection && this.isOutputTypeMessage() ? this.convertMultipleOutputValuesIfNecessary(output, ObjectUtils.isEmpty((Object[])contentType) ? null : contentType) : (ObjectUtils.isArray((Object)output) && !(output instanceof byte[]) ? this.convertMultipleOutputValuesIfNecessary(output, ObjectUtils.isEmpty((Object[])contentType) ? null : contentType) : SimpleFunctionRegistry.this.messageConverter.toMessage(output, new MessageHeaders(Collections.singletonMap("contentType", contentType[0])))))));
            return convertedOutput;
        }

        private boolean containsRetainMessageSignalInHeaders(Message message) {
            if (new CloudEventAttributes((Map<String, Object>)message.getHeaders()).isValidCloudEvent()) {
                return true;
            }
            for (String headerName : message.getHeaders().keySet()) {
                if (!headerName.startsWith("lambda") && !headerName.startsWith("scf-func-name")) continue;
                return true;
            }
            return false;
        }

        private Object convertNonMessageInputIfNecessary(Type inputType, Object input, boolean maybeJson) {
            Class<?> rawInputType;
            Object convertedInput = null;
            Class<?> clazz = rawInputType = this.isTypePublisher(inputType) || this.isInputTypeMessage() ? FunctionTypeUtils.getRawType(FunctionTypeUtils.getGenericType(inputType)) : this.getRawClassFor(inputType);
            if (maybeJson && !Message.class.isAssignableFrom(rawInputType)) {
                if (FunctionTypeUtils.isMessage(inputType)) {
                    inputType = FunctionTypeUtils.getGenericType(inputType);
                }
                if (Object.class != inputType) {
                    convertedInput = SimpleFunctionRegistry.this.jsonMapper.fromJson(input, inputType);
                }
            } else if (SimpleFunctionRegistry.this.conversionService != null && !rawInputType.equals(input.getClass()) && SimpleFunctionRegistry.this.conversionService.canConvert(input.getClass(), rawInputType)) {
                convertedInput = SimpleFunctionRegistry.this.conversionService.convert(input, rawInputType);
            }
            if (convertedInput == null && input.getClass().isAssignableFrom(rawInputType)) {
                convertedInput = input;
            }
            return convertedInput;
        }

        private boolean isWrapConvertedInputInMessage(Object convertedInput) {
            return this.inputType != null && FunctionTypeUtils.isMessage(this.inputType) && !(convertedInput instanceof Message) && !(convertedInput instanceof Publisher) && !(convertedInput instanceof OriginalMessageHolder);
        }

        private Type extractActualValueTypeIfNecessary(Type type) {
            if (type instanceof ParameterizedType && (FunctionTypeUtils.isPublisher(type) || FunctionTypeUtils.isMessage(type))) {
                return FunctionTypeUtils.getGenericType(type);
            }
            return type;
        }

        private boolean isConversionHintRequired(Object actualType, Class<?> rawType) {
            return rawType != actualType;
        }

        private Object convertInputMessageIfNecessary(Message message, Type type) {
            Class<?> rawType;
            if (type == null) {
                return null;
            }
            if (message.getPayload() instanceof Optional) {
                return message;
            }
            if (message.getPayload() instanceof Collection) {
                Type itemType = FunctionTypeUtils.getImmediateGenericType(type, 0);
                Class collectionType = CollectionUtils.findCommonElementType((Collection)((Collection)message.getPayload()));
                if (collectionType == itemType) {
                    return message.getPayload();
                }
            }
            Object convertedInput = message;
            Message message2 = convertedInput = this.isConversionHintRequired(type = this.extractActualValueTypeIfNecessary(type), rawType = FunctionTypeUtils.getRawType(type)) ? SimpleFunctionRegistry.this.messageConverter.fromMessage(message, rawType, (Object)type) : SimpleFunctionRegistry.this.messageConverter.fromMessage(message, rawType);
            if (this.isInputTypeMessage()) {
                if (convertedInput == null) {
                    SimpleFunctionRegistry.this.logger.info((Object)("Input type conversion of payload " + message.getPayload() + " resulted in 'null'. Will use the original message as input."));
                    convertedInput = message;
                } else if (!(convertedInput instanceof Message)) {
                    convertedInput = MessageBuilder.withPayload((Object)convertedInput).copyHeaders((Map)message.getHeaders()).build();
                }
            }
            return convertedInput;
        }

        private Object convertMultipleOutputArgumentTypeIfNecesary(Object output, Type type, String[] contentType) {
            Type[] outputTypes = ((ParameterizedType)type).getActualTypeArguments();
            Object[] multipleValueArguments = this.parseMultipleValueArguments(output, outputTypes.length);
            Object[] convertedOutputs = new Object[outputTypes.length];
            for (int i = 0; i < multipleValueArguments.length; ++i) {
                Object convertedInput;
                String[] stringArray;
                if (!ObjectUtils.isEmpty((Object[])contentType)) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = contentType[i];
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "application/json";
                }
                String[] ctToUse = stringArray;
                convertedOutputs[i] = convertedInput = this.convertOutputIfNecessary(multipleValueArguments[i], outputTypes[i], ctToUse);
            }
            return Tuples.fromArray((Object[])convertedOutputs);
        }

        private Object convertOutputMessageIfNecessary(Object output, String expectedOutputContetntType) {
            String contentType;
            Map headersMap = (Map)ReflectionUtils.getField((Field)SimpleFunctionRegistry.this.headersField, (Object)((Message)output).getHeaders());
            String string = contentType = ((Message)output).getHeaders().containsKey((Object)"expected-content-type") ? (String)((Message)output).getHeaders().get((Object)"expected-content-type") : expectedOutputContetntType;
            if (StringUtils.hasText((String)contentType)) {
                String[] expectedContentTypes;
                for (String expectedContentType : expectedContentTypes = StringUtils.delimitedListToStringArray((String)contentType, (String)",")) {
                    headersMap.put("contentType", expectedContentType);
                    Message result = SimpleFunctionRegistry.this.messageConverter.toMessage(((Message)output).getPayload(), ((Message)output).getHeaders());
                    if (result == null) continue;
                    return result;
                }
            }
            return output;
        }

        private Object convertMultipleOutputValuesIfNecessary(Object output, String[] contentType) {
            Collection outputCollection = ObjectUtils.isArray((Object)output) ? CollectionUtils.arrayToList((Object)output) : (Collection)output;
            AbstractCollection convertedOutputCollection = outputCollection instanceof List ? new ArrayList() : new TreeSet();
            Type type = this.isOutputTypeMessage() ? FunctionTypeUtils.getGenericType(this.outputType) : this.outputType;
            for (Object outToConvert : outputCollection) {
                Object result = this.convertOutputIfNecessary(outToConvert, type, contentType);
                Assert.notNull((Object)result, () -> "Failed to convert output '" + outToConvert + "'");
                convertedOutputCollection.add(result);
            }
            return ObjectUtils.isArray((Object)output) ? convertedOutputCollection.toArray() : convertedOutputCollection;
        }

        private Object convertInputPublisherIfNecessary(Publisher publisher, Type type) {
            Type actualType = type != null ? FunctionTypeUtils.getGenericType(type) : type;
            return publisher instanceof Mono ? Mono.from((Publisher)publisher).map(v -> this.convertInputIfNecessary(v, actualType)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)"Failed to convert input", (Throwable)ex)) : Flux.from((Publisher)publisher).map(v -> this.convertInputIfNecessary(v, actualType)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)"Failed to convert input", (Throwable)ex));
        }

        private Object convertOutputPublisherIfNecessary(Publisher publisher, Type type, String[] expectedOutputContentType) {
            return publisher instanceof Mono ? Mono.from((Publisher)publisher).map(v -> this.convertOutputIfNecessary(v, type, expectedOutputContentType)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)"Failed to convert output", (Throwable)ex)) : Flux.from((Publisher)publisher).map(v -> this.convertOutputIfNecessary(v, type, expectedOutputContentType)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)"Failed to convert output", (Throwable)ex));
        }

        static /* synthetic */ String[] access$002(FunctionInvocationWrapper x0, String[] x1) {
            x0.expectedOutputContentType = x1;
            return x1;
        }
    }
}

