/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionRegistrationEvent;
import org.springframework.cloud.function.context.catalog.MessageConsumer;
import org.springframework.cloud.function.context.catalog.MessageFunction;
import org.springframework.cloud.function.context.catalog.MessageSupplier;
import org.springframework.cloud.function.core.FluxToMonoFunction;
import org.springframework.cloud.function.core.IsolatedConsumer;
import org.springframework.cloud.function.core.IsolatedFunction;
import org.springframework.cloud.function.core.IsolatedSupplier;
import org.springframework.cloud.function.core.MonoToFluxFunction;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractComposableFunctionRegistry
implements FunctionRegistry,
FunctionInspector,
ApplicationEventPublisherAware,
EnvironmentAware {
    private final Map<String, Object> functions = new ConcurrentHashMap<String, Object>();
    private final Map<Object, String> names = new ConcurrentHashMap<Object, String>();
    private final Map<String, FunctionType> types = new ConcurrentHashMap<String, FunctionType>();
    private Environment environment = new StandardEnvironment();
    protected ApplicationEventPublisher applicationEventPublisher;

    @Override
    public <T> T lookup(Class<?> type, String name) {
        String functionDefinitionName = !StringUtils.hasText((String)name) && this.environment.containsProperty("spring.cloud.function.definition") ? this.environment.getProperty("spring.cloud.function.definition") : name;
        return (T)this.doLookup(type, functionDefinitionName);
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        if (type == null) {
            return new HashSet<String>(this.getSupplierNames()){
                {
                    this.addAll(AbstractComposableFunctionRegistry.this.getFunctionNames());
                }
            };
        }
        if (Supplier.class.isAssignableFrom(type)) {
            return this.getSupplierNames();
        }
        if (Function.class.isAssignableFrom(type)) {
            return this.getFunctionNames();
        }
        return Collections.emptySet();
    }

    public Set<String> getSupplierNames() {
        return this.functions.entrySet().stream().filter(entry -> entry.getValue() instanceof Supplier).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }

    public Set<String> getFunctionNames() {
        return this.functions.entrySet().stream().filter(entry -> !(entry.getValue() instanceof Supplier)).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }

    public boolean hasSuppliers() {
        return !CollectionUtils.isEmpty(this.getSupplierNames());
    }

    public boolean hasFunctions() {
        return !CollectionUtils.isEmpty(this.getFunctionNames());
    }

    @Override
    public int size() {
        return this.functions.size();
    }

    public FunctionType getFunctionType(String name) {
        return this.types.get(name);
    }

    public String lookupFunctionName(Object function) {
        return this.names.containsKey(function) ? this.names.get(function) : null;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public FunctionRegistration<?> getRegistration(Object function) {
        String functionName;
        String string = functionName = function == null ? null : this.lookupFunctionName(function);
        if (StringUtils.hasText((String)functionName)) {
            FunctionRegistration<Object> registration = new FunctionRegistration<Object>(function, functionName);
            FunctionType functionType = this.findType(registration, functionName);
            return registration.type(functionType.getType());
        }
        return null;
    }

    @Override
    public <T> void register(FunctionRegistration<T> functionRegistration) {
        Assert.notEmpty(functionRegistration.getNames(), (String)"'registration' must contain at least one name before it is registered in catalog.");
        this.register(functionRegistration, functionRegistration.getNames().iterator().next());
    }

    protected void register(FunctionRegistration<?> registration, String key) {
        Class type;
        Object target = registration.getTarget();
        if (registration.getType() != null) {
            this.addType(key, registration.getType());
        } else {
            FunctionType functionType = this.findType(registration, key);
            if (functionType == null) {
                return;
            }
            this.addType(key, functionType);
            registration.type(functionType.getType());
        }
        registration = this.isolated(registration).wrap();
        target = registration.getTarget();
        if (target instanceof Supplier) {
            type = Supplier.class;
            for (String name : registration.getNames()) {
                this.addSupplier(name, (Supplier)registration.getTarget());
            }
        } else if (target instanceof Function) {
            type = Function.class;
            for (String name : registration.getNames()) {
                this.addFunction(name, (Function)registration.getTarget());
            }
        } else {
            return;
        }
        this.addName(registration.getTarget(), key);
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new FunctionRegistrationEvent(registration.getTarget(), type, registration.getNames()));
        }
    }

    protected FunctionType findType(FunctionRegistration<?> functionRegistration, String name) {
        return functionRegistration.getType() != null ? functionRegistration.getType() : this.getFunctionType(name);
    }

    protected void addSupplier(String name, Supplier<?> supplier) {
        this.functions.put(name, supplier);
    }

    protected void addFunction(String name, Function<?, ?> function) {
        this.functions.put(name, function);
    }

    protected void addType(String name, FunctionType functionType) {
        this.types.computeIfAbsent(name, str -> functionType);
    }

    protected void addName(Object function, String name) {
        this.names.put(function, name);
    }

    private FunctionRegistration<?> isolated(FunctionRegistration<?> input) {
        boolean isolated;
        FunctionRegistration<?> registration = input;
        Object target = registration.getTarget();
        boolean bl = isolated = this.getClass().getClassLoader() != target.getClass().getClassLoader();
        if (isolated) {
            if (target instanceof Supplier && isolated) {
                target = new IsolatedSupplier((Supplier)target);
            } else if (target instanceof Function) {
                target = new IsolatedFunction((Function)target);
            } else if (target instanceof Consumer) {
                target = new IsolatedConsumer((Consumer)target);
            }
        }
        registration.target(target);
        return registration;
    }

    private Object compose(String name, Map<String, Object> lookup) {
        name = name.replaceAll(",", "|").trim();
        Object composedFunction = null;
        if (lookup.containsKey(name)) {
            composedFunction = lookup.get(name);
        } else if (name.equals("") && lookup.size() >= 1 && lookup.size() <= 2) {
            String functionName = lookup.keySet().stream().filter(fName -> !fName.equals("functionRouter")).findFirst().orElseGet(() -> null);
            composedFunction = lookup.get(functionName);
        } else {
            String[] stages = StringUtils.delimitedListToStringArray((String)name, (String)"|");
            AtomicBoolean supplierPresent = new AtomicBoolean();
            List composableFunctions = Stream.of(stages).map(funcName -> this.find((String)funcName, supplierPresent.get())).filter(x -> x != null).peek(f -> supplierPresent.set(f.getTarget() instanceof Supplier)).collect(Collectors.toList());
            FunctionRegistration composedRegistration = composableFunctions.stream().reduce((a, z) -> this.composeFunctions((FunctionRegistration<?>)a, (FunctionRegistration<?>)z)).orElseGet(() -> null);
            if (composedRegistration != null && composedRegistration.getTarget() != null && !this.types.containsKey(name)) {
                composedFunction = composedRegistration.getTarget();
                this.addType(name, composedRegistration.getType());
                this.addName(composedFunction, name);
                if (composedFunction instanceof Function || composedFunction instanceof Consumer) {
                    this.addFunction(name, (Function)composedFunction);
                } else if (composedFunction instanceof Supplier) {
                    this.addSupplier(name, (Supplier)composedFunction);
                }
            }
        }
        return composedFunction;
    }

    private FunctionRegistration<?> find(String name, boolean supplierFound) {
        Object result = this.functions.get(name);
        if (result == null && !StringUtils.hasText((String)name)) {
            if (supplierFound && this.getFunctionNames().size() == 1) {
                result = this.functions.get(this.getFunctionNames().iterator().next());
            } else if (!supplierFound && this.getSupplierNames().size() == 1) {
                result = this.functions.get(this.getSupplierNames().iterator().next());
            }
        }
        return this.getRegistration(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FunctionRegistration<?> composeFunctions(FunctionRegistration<?> aReg, FunctionRegistration<?> bReg) {
        FunctionType aType = aReg.getType();
        FunctionType bType = bReg.getType();
        Object a = aReg.getTarget();
        Object b = bReg.getTarget();
        if (aType != null && bType != null && aType.isMessage() && !bType.isMessage()) {
            bType = bType.message();
            b = this.message(b);
        }
        FluxToMonoFunction composedFunction = null;
        if (a instanceof Function && b instanceof Function) {
            Function function1 = (Function)a;
            Function function2 = (Function)b;
            if (function1 instanceof FluxToMonoFunction) {
                if (!(function2 instanceof MonoToFluxFunction)) throw new IllegalStateException("The provided function is finite (i.e., returns Mono<?>) therefore it can *only* be composed with compatible function (i.e., Function<Mono, Flux>");
                composedFunction = function1.andThen(function2);
            } else {
                composedFunction = function2 instanceof FluxToMonoFunction ? new FluxToMonoFunction(((Function)a).andThen((Function)((FluxToMonoFunction)b).getTarget())) : function1.andThen(function2);
            }
        } else {
            if (!(a instanceof Function) || !(b instanceof Consumer)) throw new IllegalArgumentException(String.format("Could not compose %s and %s", a.getClass(), b.getClass()));
            Function function = (Function)a;
            Consumer consumer = (Consumer)b;
            composedFunction = v -> consumer.accept(function.apply(v));
        }
        String name = aReg.getNames().iterator().next() + "|" + bReg.getNames().iterator().next();
        return new FunctionRegistration<FluxToMonoFunction>(composedFunction, name).type(FunctionType.compose(aType, bType));
    }

    private Object message(Object input) {
        if (input instanceof Supplier) {
            return new MessageSupplier((Supplier)input);
        }
        if (input instanceof Consumer) {
            return new MessageConsumer((Consumer)input);
        }
        if (input instanceof Function) {
            return new MessageFunction((Function)input);
        }
        return input;
    }

    private Object doLookup(Class<?> type, String name) {
        Object function = this.compose(name, this.functions);
        if (function != null && type != null && !type.isAssignableFrom(function.getClass())) {
            function = null;
        }
        return function;
    }
}

