/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.cloudevent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.cloud.function.cloudevent.CloudEventAttributes;
import org.springframework.cloud.function.cloudevent.CloudEventAttributesProvider;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public final class CloudEventMessageUtils {
    private static final ContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver();
    public static String APPLICATION_CLOUDEVENTS_VALUE = "application/cloudevents";
    public static MimeType APPLICATION_CLOUDEVENTS = MimeTypeUtils.parseMimeType((String)APPLICATION_CLOUDEVENTS_VALUE);
    public static String DEFAULT_ATTR_PREFIX = "ce_";
    public static String HTTP_ATTR_PREFIX = "ce-";
    public static String AMQP_ATTR_PREFIX = "cloudEvents:";
    public static String DATA = "data";
    public static String CANONICAL_DATA = DEFAULT_ATTR_PREFIX + DATA;
    public static String ID = "id";
    public static String CANONICAL_ID = DEFAULT_ATTR_PREFIX + ID;
    public static String SOURCE = "source";
    public static String CANONICAL_SOURCE = DEFAULT_ATTR_PREFIX + SOURCE;
    public static String SPECVERSION = "specversion";
    public static String CANONICAL_SPECVERSION = DEFAULT_ATTR_PREFIX + SPECVERSION;
    public static String TYPE = "type";
    public static String CANONICAL_TYPE = DEFAULT_ATTR_PREFIX + TYPE;
    public static String DATACONTENTTYPE = "datacontenttype";
    public static String CANONICAL_DATACONTENTTYPE = DEFAULT_ATTR_PREFIX + DATACONTENTTYPE;
    public static String DATASCHEMA = "dataschema";
    public static String CANONICAL_DATASCHEMA = DEFAULT_ATTR_PREFIX + DATASCHEMA;
    public static String SUBJECT = "subject";
    public static String CANONICAL_SUBJECT = DEFAULT_ATTR_PREFIX + SUBJECT;
    public static String TIME = "time";
    public static String CANONICAL_TIME = DEFAULT_ATTR_PREFIX + TIME;

    private CloudEventMessageUtils() {
    }

    public static boolean isBinary(Map<String, Object> headers) {
        CloudEventAttributes attributes = new CloudEventAttributes(headers);
        return attributes.isValidCloudEvent();
    }

    public static CloudEventAttributes get(String ce_id, String ce_specversion, String ce_source, String ce_type) {
        Assert.hasText((String)ce_id, (String)"'ce_id' must not be null or empty");
        Assert.hasText((String)ce_specversion, (String)"'ce_specversion' must not be null or empty");
        Assert.hasText((String)ce_source, (String)"'ce_source' must not be null or empty");
        Assert.hasText((String)ce_type, (String)"'ce_type' must not be null or empty");
        HashMap<String, Object> requiredAttributes = new HashMap<String, Object>();
        requiredAttributes.put(CANONICAL_ID, ce_id);
        requiredAttributes.put(CANONICAL_SPECVERSION, ce_specversion);
        requiredAttributes.put(CANONICAL_SOURCE, ce_source);
        requiredAttributes.put(CANONICAL_TYPE, ce_type);
        return new CloudEventAttributes((Map<String, Object>)requiredAttributes);
    }

    public static CloudEventAttributes get(String ce_source, String ce_type) {
        return CloudEventMessageUtils.get(UUID.randomUUID().toString(), "1.0", ce_source, ce_type);
    }

    public static Message<?> toBinary(Message<?> inputMessage, MessageConverter messageConverter) {
        MessageHeaders headers = inputMessage.getHeaders();
        CloudEventAttributes attributes = new CloudEventAttributes((Map<String, Object>)headers);
        if (!attributes.isValidCloudEvent() && headers.containsKey("contentType")) {
            MimeType contentType = CloudEventMessageUtils.resolveContentType(inputMessage.getHeaders());
            if (contentType != null && contentType.getType().equals(APPLICATION_CLOUDEVENTS.getType()) && contentType.getSubtype().startsWith(APPLICATION_CLOUDEVENTS.getSubtype())) {
                String dataContentType = StringUtils.hasText((String)((String)attributes.getDataContentType())) ? (String)attributes.getDataContentType() : "application/json";
                String suffix = contentType.getSubtypeSuffix();
                Assert.hasText((String)suffix, (String)("Content-type 'suffix' can not be determined from " + contentType));
                MimeType cloudEventDeserializationContentType = MimeTypeUtils.parseMimeType((String)(contentType.getType() + "/" + suffix));
                Message cloudEventMessage = MessageBuilder.fromMessage(inputMessage).setHeader("contentType", (Object)cloudEventDeserializationContentType).setHeader(CANONICAL_DATACONTENTTYPE, (Object)dataContentType).build();
                Map structuredCloudEvent = (Map)messageConverter.fromMessage(cloudEventMessage, Map.class);
                Message<?> binaryCeMessage = CloudEventMessageUtils.buildCeMessageFromStructured(structuredCloudEvent, inputMessage.getHeaders());
                return binaryCeMessage;
            }
        } else if (StringUtils.hasText((String)((String)attributes.getDataContentType()))) {
            return MessageBuilder.fromMessage(inputMessage).setHeader("contentType", attributes.getDataContentType()).build();
        }
        return inputMessage;
    }

    private static MimeType resolveContentType(MessageHeaders headers) {
        try {
            return contentTypeResolver.resolve(headers);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String determinePrefixToUse(MessageHeaders messageHeaders) {
        Set keys = messageHeaders.keySet();
        if (keys.contains("user-agent")) {
            return HTTP_ATTR_PREFIX;
        }
        if (keys.contains("amqp")) {
            return AMQP_ATTR_PREFIX;
        }
        return DEFAULT_ATTR_PREFIX;
    }

    public static CloudEventAttributes generateAttributes(Message<?> message, CloudEventAttributesProvider provider) {
        CloudEventAttributes attributes = CloudEventMessageUtils.generateDefaultAttributeValues(new CloudEventAttributes((Map<String, Object>)message.getHeaders()), message.getPayload().getClass().getName().getClass().getName(), message.getPayload().getClass().getName().getClass().getName());
        provider.generateDefaultCloudEventHeaders(attributes);
        return attributes;
    }

    public static CloudEventAttributes generateAttributes(Message<?> inputMessage, String typeName, String sourceName) {
        CloudEventAttributes attributes = new CloudEventAttributes((Map<String, Object>)inputMessage.getHeaders(), CloudEventMessageUtils.determinePrefixToUse(inputMessage.getHeaders()));
        return CloudEventMessageUtils.generateDefaultAttributeValues(attributes, sourceName, typeName);
    }

    private static Message<?> buildCeMessageFromStructured(Map<String, Object> structuredCloudEvent, MessageHeaders originalHeaders) {
        String prefixToUse = CloudEventMessageUtils.determinePrefixToUse(originalHeaders);
        Object data = null;
        if (structuredCloudEvent.containsKey(HTTP_ATTR_PREFIX + DATA)) {
            data = structuredCloudEvent.get(HTTP_ATTR_PREFIX + DATA);
            structuredCloudEvent.remove(HTTP_ATTR_PREFIX + DATA);
        } else if (structuredCloudEvent.containsKey(CANONICAL_DATA)) {
            data = structuredCloudEvent.get(CANONICAL_DATA);
            structuredCloudEvent.remove(CANONICAL_DATA);
        } else if (structuredCloudEvent.containsKey(DATA)) {
            data = structuredCloudEvent.get(DATA);
            structuredCloudEvent.remove(DATA);
        }
        Assert.notNull((Object)data, (String)"'data' must not be null");
        MessageBuilder builder = MessageBuilder.withPayload((Object)data);
        CloudEventAttributes attributes = new CloudEventAttributes(structuredCloudEvent);
        builder.setHeader(prefixToUse + ID, attributes.getId());
        builder.setHeader(prefixToUse + SOURCE, attributes.getSource());
        builder.setHeader(prefixToUse + TYPE, attributes.getType());
        builder.setHeader(prefixToUse + SPECVERSION, attributes.getSpecversion());
        builder.copyHeaders((Map)originalHeaders);
        return builder.build();
    }

    private static CloudEventAttributes generateDefaultAttributeValues(CloudEventAttributes attributes, String source, String type) {
        if (attributes.isValidCloudEvent()) {
            return attributes.setSpecversion("1.0").setId(UUID.randomUUID().toString()).setType(type).setSource(source);
        }
        return attributes;
    }
}

