/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.cloudevent;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.util.StringUtils;

public class CloudEventAttributes
extends HashMap<String, Object> {
    private static final long serialVersionUID = 5393610770855366497L;
    private final String prefixToUse;

    public CloudEventAttributes(Map<String, Object> headers, String prefixToUse) {
        super(headers);
        this.prefixToUse = prefixToUse;
    }

    public CloudEventAttributes(Map<String, Object> headers) {
        this(headers, null);
    }

    public CloudEventAttributes setId(String id) {
        this.setAttribute(CloudEventMessageUtils.ID, id);
        return this;
    }

    public <A> A getId() {
        A id = this.getAttribute(CloudEventMessageUtils.ID);
        if (id instanceof UUID) {
            id = null;
        }
        return id;
    }

    public CloudEventAttributes setSource(String source) {
        this.setAttribute(CloudEventMessageUtils.SOURCE, source);
        return this;
    }

    public <A> A getSource() {
        return this.getAttribute(CloudEventMessageUtils.SOURCE);
    }

    public CloudEventAttributes setSpecversion(String specversion) {
        this.setAttribute(CloudEventMessageUtils.SPECVERSION, specversion);
        return this;
    }

    public <A> A getSpecversion() {
        return this.getAttribute(CloudEventMessageUtils.SPECVERSION);
    }

    public CloudEventAttributes setType(String type) {
        this.setAttribute(CloudEventMessageUtils.TYPE, type);
        return this;
    }

    public <A> A getType() {
        return this.getAttribute(CloudEventMessageUtils.TYPE);
    }

    public CloudEventAttributes setDataContentType(String datacontenttype) {
        this.setAttribute(CloudEventMessageUtils.DATACONTENTTYPE, datacontenttype);
        return this;
    }

    public <A> A getDataContentType() {
        return this.getAttribute(CloudEventMessageUtils.DATACONTENTTYPE);
    }

    public CloudEventAttributes setDataSchema(String dataschema) {
        this.setAttribute(CloudEventMessageUtils.DATASCHEMA, dataschema);
        return this;
    }

    public <A> A getDataSchema() {
        return this.getAttribute(CloudEventMessageUtils.DATASCHEMA);
    }

    public CloudEventAttributes setSubject(String subject) {
        this.setAttribute(CloudEventMessageUtils.SUBJECT, subject);
        return this;
    }

    public <A> A getSubect() {
        return this.getAttribute(CloudEventMessageUtils.SUBJECT);
    }

    public CloudEventAttributes setTime(String time) {
        this.setAttribute(CloudEventMessageUtils.TIME, time);
        return this;
    }

    public <A> A getTime() {
        return this.getAttribute(CloudEventMessageUtils.TIME);
    }

    public <A> A getAttribute(String attrName) {
        if (this.containsKey(CloudEventMessageUtils.DEFAULT_ATTR_PREFIX + attrName)) {
            return (A)this.get(CloudEventMessageUtils.DEFAULT_ATTR_PREFIX + attrName);
        }
        if (this.containsKey(CloudEventMessageUtils.HTTP_ATTR_PREFIX + attrName)) {
            return (A)this.get(CloudEventMessageUtils.HTTP_ATTR_PREFIX + attrName);
        }
        return (A)this.get(attrName);
    }

    public boolean isValidCloudEvent() {
        return StringUtils.hasText((String)((String)this.getId())) && StringUtils.hasText((String)((String)this.getSource())) && StringUtils.hasText((String)((String)this.getSpecversion())) && StringUtils.hasText((String)((String)this.getType()));
    }

    String getAttributeName(String attributeName) {
        if (this.containsKey(CloudEventMessageUtils.DEFAULT_ATTR_PREFIX + attributeName)) {
            return CloudEventMessageUtils.DEFAULT_ATTR_PREFIX + attributeName;
        }
        if (this.containsKey(CloudEventMessageUtils.HTTP_ATTR_PREFIX + attributeName)) {
            return CloudEventMessageUtils.HTTP_ATTR_PREFIX + attributeName;
        }
        return attributeName;
    }

    private CloudEventAttributes setAttribute(String attrName, String attrValue) {
        if (StringUtils.hasText((String)this.prefixToUse)) {
            this.remove(this.getAttributeName(attrName));
            this.put(this.prefixToUse + attrName, attrValue);
        } else {
            this.put(this.getAttributeName(attrName), attrValue);
        }
        return this;
    }
}

