/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanFactoryAwareFunctionRegistry
extends SimpleFunctionRegistry
implements ApplicationContextAware,
InitializingBean {
    private ConfigurableApplicationContext applicationContext;

    public BeanFactoryAwareFunctionRegistry(ConversionService conversionService, @Nullable CompositeMessageConverter messageConverter) {
        super(conversionService, messageConverter);
    }

    public void afterPropertiesSet() throws Exception {
        String userDefinition = this.applicationContext.getEnvironment().getProperty("spring.cloud.function.definition");
        this.init(userDefinition);
    }

    @Override
    public int size() {
        return this.applicationContext.getBeanNamesForType(Supplier.class).length + this.applicationContext.getBeanNamesForType(Function.class).length + this.applicationContext.getBeanNamesForType(Consumer.class).length;
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        Set<String> registeredNames = super.getNames(type);
        if (type == null) {
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(Function.class)));
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(Supplier.class)));
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(Consumer.class)));
        } else {
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(type)));
        }
        return registeredNames;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    Object locateFunction(String name) {
        Object function = super.locateFunction(name);
        if (function == null && this.applicationContext.containsBean(name)) {
            function = this.applicationContext.getBean(name);
        }
        if (function != null && this.notFunction(function.getClass()) && this.applicationContext.containsBean(name + FunctionRegistration.REGISTRATION_NAME_SUFFIX)) {
            function = this.applicationContext.getBean(name + FunctionRegistration.REGISTRATION_NAME_SUFFIX, FunctionRegistration.class);
        }
        return function;
    }

    @Override
    Type discoverFunctionType(Object function, String ... names) {
        Type t;
        if (function instanceof RoutingFunction) {
            return FunctionType.of(FunctionContextUtils.findType(this.applicationContext.getBeanFactory(), names)).getType();
        }
        boolean beanDefinitionExists = false;
        for (int i = 0; i < names.length && !beanDefinitionExists; ++i) {
            beanDefinitionExists = this.applicationContext.getBeanFactory().containsBeanDefinition(names[i]);
            if (!this.applicationContext.containsBean("&" + names[i])) continue;
            Class objectType = ((FactoryBean)this.applicationContext.getBean("&" + names[i], FactoryBean.class)).getObjectType();
            return FunctionTypeUtils.discoverFunctionTypeFromClass(objectType);
        }
        if (!beanDefinitionExists) {
            this.logger.info((Object)("BeanDefinition for function name(s) '" + Arrays.asList(names) + "' can not be located. FunctionType will be based on " + function.getClass()));
        }
        Type type = FunctionTypeUtils.discoverFunctionTypeFromClass(function.getClass());
        if (beanDefinitionExists && ((t = FunctionTypeUtils.getImmediateGenericType(type, 0)) == null || t == Object.class)) {
            type = FunctionType.of(FunctionContextUtils.findType(this.applicationContext.getBeanFactory(), names)).getType();
        }
        return type;
    }

    @Override
    String discoverDefaultDefinitionIfNecessary(String definition) {
        if (StringUtils.isEmpty((Object)definition) || definition.endsWith("|")) {
            Type functionType;
            String[] functionNames = (String[])Stream.of(this.applicationContext.getBeanNamesForType(Function.class)).filter(n -> !n.endsWith(FunctionRegistration.REGISTRATION_NAME_SUFFIX) && !n.equals("functionRouter")).toArray(String[]::new);
            String[] consumerNames = (String[])Stream.of(this.applicationContext.getBeanNamesForType(Consumer.class)).filter(n -> !n.endsWith(FunctionRegistration.REGISTRATION_NAME_SUFFIX) && !n.equals("functionRouter")).toArray(String[]::new);
            String[] supplierNames = (String[])Stream.of(this.applicationContext.getBeanNamesForType(Supplier.class)).filter(n -> !n.endsWith(FunctionRegistration.REGISTRATION_NAME_SUFFIX) && !n.equals("functionRouter")).toArray(String[]::new);
            List names = Stream.concat(Stream.of(functionNames), Stream.concat(Stream.of(consumerNames), Stream.of(supplierNames))).collect(Collectors.toList());
            if (definition.endsWith("|")) {
                Set<String> fNames = this.getNames(null);
                definition = this.determinImpliedDefinition(fNames, definition);
            } else if (!ObjectUtils.isEmpty(names)) {
                if (names.size() > 1) {
                    this.logger.info((Object)("Found more then one function beans in BeanFactory: " + names + ". If you did not intend to use functions, ignore this message. However, if you did intend to use functions in the context of spring-cloud-function, consider providing 'spring.cloud.function.definition' property pointing to a function bean(s) you intend to use. For example, 'spring.cloud.function.definition=myFunction'"));
                    return null;
                }
                definition = (String)names.get(0);
            } else {
                definition = this.discoverDefaultDefinitionFromRegistration();
            }
            if (StringUtils.hasText((String)definition) && this.applicationContext.containsBean(definition) && !FunctionTypeUtils.isSupplier(functionType = this.discoverFunctionType(this.applicationContext.getBean(definition), definition)) && !FunctionTypeUtils.isFunction(functionType) && !FunctionTypeUtils.isConsumer(functionType)) {
                this.logger.info((Object)("Discovered functional instance of bean '" + definition + "' as a default function, however its function argument types can not be determined. Discarding."));
                definition = null;
            }
        }
        return definition;
    }

    @Override
    Type discovereFunctionTypeByName(String name) {
        return FunctionContextUtils.findType(this.applicationContext.getBeanFactory(), name);
    }

    @Override
    Collection<String> getAliases(String key) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String value = this.getQualifier(key);
        if (value.equals(key) && this.applicationContext != null) {
            names.addAll(Arrays.asList(this.applicationContext.getBeanFactory().getAliases(key)));
        }
        names.add(value);
        return names;
    }

    private boolean notFunction(Class<?> functionClass) {
        return !Function.class.isAssignableFrom(functionClass) && !Supplier.class.isAssignableFrom(functionClass) && !Consumer.class.isAssignableFrom(functionClass);
    }

    private String getQualifier(String key) {
        StandardMethodMetadata metadata;
        Qualifier qualifier;
        BeanDefinition beanDefinition;
        Object source;
        if (this.applicationContext != null && this.applicationContext.getBeanFactory().containsBeanDefinition(key) && (source = (beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(key)).getSource()) instanceof StandardMethodMetadata && (qualifier = (Qualifier)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)(metadata = (StandardMethodMetadata)source).getIntrospectedMethod(), Qualifier.class)) != null && qualifier.value().length() > 0) {
            return qualifier.value();
        }
        return key;
    }
}

