/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.Collections;
import java.util.Set;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.AbstractComposableFunctionRegistry;
import org.springframework.util.Assert;

public class InMemoryFunctionCatalog
extends AbstractComposableFunctionRegistry {
    public InMemoryFunctionCatalog() {
        this(Collections.emptySet());
    }

    public InMemoryFunctionCatalog(Set<FunctionRegistration<?>> registrations) {
        Assert.notNull(registrations, (String)"'registrations' must not be null");
        registrations.stream().forEach(reg -> this.register(reg));
    }

    @Override
    protected FunctionType findType(FunctionRegistration<?> functionRegistration, String name) {
        FunctionType functionType = super.findType(functionRegistration, name);
        if (functionType == null) {
            functionType = new FunctionType(functionRegistration.getTarget().getClass());
        }
        return functionType;
    }
}

