/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.BeanFactoryAwareFunctionRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import reactor.util.function.Tuple2;

public final class FunctionTypeUtils {
    private FunctionTypeUtils() {
    }

    public static boolean isTypeCollection(Type type) {
        if (FunctionTypeUtils.isMessage(type)) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        Type rawType = type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type;
        return rawType instanceof Class && Collection.class.isAssignableFrom((Class)rawType);
    }

    public static Method discoverFunctionalMethod(Class<?> pojoFunctionClass) {
        if (Supplier.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("get")).findFirst().get();
        }
        if (Consumer.class.isAssignableFrom(pojoFunctionClass) || BiConsumer.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("accept")).findFirst().get();
        }
        if (Function.class.isAssignableFrom(pojoFunctionClass) || BiFunction.class.isAssignableFrom(pojoFunctionClass)) {
            return Stream.of(ReflectionUtils.getDeclaredMethods(pojoFunctionClass)).filter(m -> !m.isSynthetic() && m.getName().equals("apply")).findFirst().get();
        }
        ArrayList methods = new ArrayList();
        ReflectionUtils.doWithMethods(pojoFunctionClass, method -> {
            if (method.getDeclaringClass() == pojoFunctionClass) {
                methods.add(method);
            }
        }, method -> !method.getDeclaringClass().isAssignableFrom(Object.class) && !method.isSynthetic() && !method.isBridge() && !method.isVarArgs());
        Assert.isTrue((methods.size() == 1 ? 1 : 0) != 0, (String)("Discovered " + methods.size() + " methods that would qualify as 'functional' - " + methods + ".\n Class '" + pojoFunctionClass + "' is not a FunctionalInterface."));
        return (Method)methods.get(0);
    }

    public static Type discoverFunctionTypeFromFunctionalObject(Object functionalObject) {
        if (functionalObject instanceof BeanFactoryAwareFunctionRegistry.FunctionInvocationWrapper) {
            return ((BeanFactoryAwareFunctionRegistry.FunctionInvocationWrapper)functionalObject).getFunctionType();
        }
        return FunctionTypeUtils.discoverFunctionTypeFromClass(functionalObject.getClass());
    }

    public static Type discoverFunctionTypeFromClass(Class<?> functionalClass) {
        Assert.isTrue((boolean)FunctionTypeUtils.isFunctional(functionalClass), (String)"Type must be one of Supplier, Function or Consumer");
        Object[] generics = functionalClass.getGenericInterfaces();
        if (ObjectUtils.isEmpty((Object[])generics)) {
            return functionalClass;
        }
        int n = 0;
        Object[] objectArray = generics;
        int n2 = objectArray.length;
        if (n < n2) {
            Object generic = objectArray[n];
            if (generic instanceof ParameterizedType) {
                Class rawClsss = (Class)((ParameterizedType)generic).getRawType();
                if (rawClsss.isAssignableFrom(Function.class) || rawClsss.isAssignableFrom(Consumer.class) || rawClsss.isAssignableFrom(Supplier.class)) {
                    return generic;
                }
                return FunctionTypeUtils.discoverFunctionTypeFromClass(rawClsss);
            }
            return FunctionTypeUtils.discoverFunctionTypeFromClass((Class)generic);
        }
        return null;
    }

    public static Type discoverFunctionTypeFromFunctionMethod(Method functionMethod) {
        Assert.isTrue((functionMethod.getName().equals("apply") || functionMethod.getName().equals("accept") || functionMethod.getName().equals("get") ? 1 : 0) != 0, (String)("Only Supplier, Function or Consumer supported at the moment. Was " + functionMethod.getDeclaringClass()));
        if (functionMethod.getName().equals("apply")) {
            return ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionMethod, (int)0), ResolvableType.forMethodReturnType((Method)functionMethod)}).getType();
        }
        if (functionMethod.getName().equals("accept")) {
            return ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionMethod, (int)0)}).getType();
        }
        return ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodReturnType((Method)functionMethod)}).getType();
    }

    public static Type unwrapActualTypeByIndex(Type type, int index) {
        if (FunctionTypeUtils.isMessage(type) || FunctionTypeUtils.isPublisher(type)) {
            if (FunctionTypeUtils.isPublisher(type)) {
                return FunctionTypeUtils.unwrapActualTypeByIndex(FunctionTypeUtils.getImmediateGenericType(type, index), index);
            }
            if (FunctionTypeUtils.isMessage(type)) {
                return FunctionTypeUtils.unwrapActualTypeByIndex(FunctionTypeUtils.getImmediateGenericType(type, index), index);
            }
        }
        return type;
    }

    public static int getInputCount(Type functionType) {
        Type inputType;
        int inputCount;
        FunctionTypeUtils.assertSupportedTypes(functionType);
        int n = inputCount = FunctionTypeUtils.isSupplier(functionType) ? 0 : 1;
        if (functionType instanceof ParameterizedType && !FunctionTypeUtils.isSupplier(functionType) && FunctionTypeUtils.isMulti(inputType = ((ParameterizedType)functionType).getActualTypeArguments()[0])) {
            inputCount = ((ParameterizedType)inputType).getActualTypeArguments().length;
        }
        return inputCount;
    }

    public static int getOutputCount(Type functionType) {
        Type inputType;
        int inputCount;
        FunctionTypeUtils.assertSupportedTypes(functionType);
        int n = inputCount = FunctionTypeUtils.isConsumer(functionType) ? 0 : 1;
        if (functionType instanceof ParameterizedType && !FunctionTypeUtils.isConsumer(functionType) && FunctionTypeUtils.isMulti(inputType = ((ParameterizedType)functionType).getActualTypeArguments()[FunctionTypeUtils.isSupplier(functionType) ? 0 : 1])) {
            inputCount = ((ParameterizedType)inputType).getActualTypeArguments().length;
        }
        return inputCount;
    }

    public static Type getInputType(Type functionType, int index) {
        Object inputType;
        FunctionTypeUtils.assertSupportedTypes(functionType);
        if (FunctionTypeUtils.isSupplier(functionType)) {
            return FunctionTypeUtils.getOutputType(functionType, index);
        }
        Object object = inputType = FunctionTypeUtils.isSupplier(functionType) ? null : Object.class;
        if ((FunctionTypeUtils.isFunction(functionType) || FunctionTypeUtils.isConsumer(functionType)) && functionType instanceof ParameterizedType) {
            inputType = ((ParameterizedType)functionType).getActualTypeArguments()[0];
            inputType = FunctionTypeUtils.isMulti((Type)inputType) ? ((ParameterizedType)inputType).getActualTypeArguments()[index] : inputType;
        }
        return inputType;
    }

    public static Type getOutputType(Type functionType, int index) {
        Object outputType;
        FunctionTypeUtils.assertSupportedTypes(functionType);
        Object object = outputType = FunctionTypeUtils.isConsumer(functionType) ? null : Object.class;
        if ((FunctionTypeUtils.isFunction(functionType) || FunctionTypeUtils.isSupplier(functionType)) && functionType instanceof ParameterizedType) {
            outputType = ((ParameterizedType)functionType).getActualTypeArguments()[FunctionTypeUtils.isFunction(functionType) ? 1 : 0];
            outputType = FunctionTypeUtils.isMulti((Type)outputType) ? ((ParameterizedType)outputType).getActualTypeArguments()[index] : outputType;
        }
        return outputType;
    }

    public static Type getImmediateGenericType(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return null;
    }

    public static Class<? extends Publisher<?>> getPublisherType(Type type) {
        if (type instanceof ParameterizedType && FunctionTypeUtils.isReactive(type)) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new IllegalStateException("The provided type is not a Publisher");
    }

    public static boolean isPublisher(Type type) {
        return FunctionTypeUtils.isFlux(type) || FunctionTypeUtils.isMono(type);
    }

    public static boolean isFlux(Type type) {
        type = FunctionTypeUtils.extractReactiveType(type);
        return type.getTypeName().startsWith("reactor.core.publisher.Flux");
    }

    public static boolean isMessage(Type type) {
        if (FunctionTypeUtils.isPublisher(type)) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        return type.getTypeName().startsWith("org.springframework.messaging.Message");
    }

    public static boolean isInputArray(Type functionType) {
        Type inputType = FunctionTypeUtils.getInputType(functionType, 0);
        return inputType instanceof GenericArrayType || inputType instanceof Class && ((Class)inputType).isArray();
    }

    public static boolean isOutputArray(Type functionType) {
        Type outputType = FunctionTypeUtils.getOutputType(functionType, 0);
        return outputType instanceof GenericArrayType || outputType instanceof Class && ((Class)outputType).isArray();
    }

    public static boolean isReactive(Type type) {
        Class rawType = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (type instanceof Class ? (Class)type : Object.class);
        return Publisher.class.isAssignableFrom(rawType);
    }

    public static boolean isSupplier(Type type) {
        return FunctionTypeUtils.isOfType(type, Supplier.class);
    }

    public static boolean isFunction(Type type) {
        return FunctionTypeUtils.isOfType(type, Function.class);
    }

    public static boolean isConsumer(Type type) {
        return FunctionTypeUtils.isOfType(type, Consumer.class);
    }

    public static boolean isOfType(Type type, Class<?> cls) {
        Class c = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        return cls.isAssignableFrom(c);
    }

    public static boolean isMono(Type type) {
        type = FunctionTypeUtils.extractReactiveType(type);
        return type.getTypeName().startsWith("reactor.core.publisher.Mono");
    }

    public static boolean isFunctional(Type type) {
        Class candidateType;
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            Assert.isTrue((boolean)(type instanceof Class), (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
        }
        return Supplier.class.isAssignableFrom(candidateType = (Class)type) || Function.class.isAssignableFrom(candidateType) || Consumer.class.isAssignableFrom(candidateType);
    }

    public static boolean isMultipleInputArguments(Type functionType) {
        boolean multipleInputs = false;
        if (functionType instanceof ParameterizedType && !FunctionTypeUtils.isSupplier(functionType)) {
            Type inputType = ((ParameterizedType)functionType).getActualTypeArguments()[0];
            multipleInputs = FunctionTypeUtils.isMulti(inputType);
        }
        return multipleInputs;
    }

    public static boolean isMultipleArgumentsHolder(Object argument) {
        return argument != null && argument.getClass().getName().startsWith("reactor.util.function.Tuple");
    }

    public static Type compose(Type originType, Type composedType) {
        ResolvableType resolvableOriginType = ResolvableType.forType((Type)originType);
        ResolvableType resolvableComposedType = ResolvableType.forType((Type)composedType);
        if (FunctionTypeUtils.isSupplier(originType)) {
            if (FunctionTypeUtils.isFunction(composedType)) {
                ResolvableType resolvableLastArgument = resolvableComposedType.getGenerics()[1];
                resolvableLastArgument = FunctionTypeUtils.isPublisher(resolvableOriginType.getGeneric(new int[]{0}).getType()) ? ResolvableType.forClassWithGenerics((Class)resolvableOriginType.getGeneric(new int[]{0}).getRawClass(), (ResolvableType[])new ResolvableType[]{resolvableLastArgument}) : resolvableLastArgument;
                originType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{resolvableLastArgument}).getType();
            }
        } else {
            ResolvableType outType = FunctionTypeUtils.isConsumer(composedType) ? ResolvableType.forClass(Void.class) : (ObjectUtils.isEmpty((Object[])resolvableComposedType.getGenerics()) ? ResolvableType.forClass(Object.class) : resolvableComposedType.getGenerics()[1]);
            originType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ObjectUtils.isEmpty((Object[])resolvableOriginType.getGenerics()) ? resolvableOriginType : resolvableOriginType.getGenerics()[0], outType}).getType();
        }
        return originType;
    }

    static Type fromFunctionMethod(Method functionalMethod) {
        Type[] parameterTypes = functionalMethod.getGenericParameterTypes();
        Type functionType = null;
        switch (parameterTypes.length) {
            case 0: {
                functionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodReturnType((Method)functionalMethod)}).getType();
                break;
            }
            case 1: {
                if (Void.class.isAssignableFrom(functionalMethod.getReturnType())) {
                    functionType = ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionalMethod, (int)0)}).getType();
                    break;
                }
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionalMethod, (int)0), ResolvableType.forMethodReturnType((Method)functionalMethod)}).getType();
                break;
            }
            case 2: {
                ResolvableType canonicalParametersWrapper = FunctionTypeUtils.fromTwoArityFunction(functionalMethod);
                functionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{canonicalParametersWrapper, ResolvableType.forMethodReturnType((Method)functionalMethod)}).getType();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Functional method: " + functionalMethod + " is not supported");
            }
        }
        return functionType;
    }

    private static ResolvableType fromTwoArityFunction(Method functionalMethod) {
        return ResolvableType.forClassWithGenerics(Tuple2.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forMethodParameter((Method)functionalMethod, (int)0), ResolvableType.forMethodParameter((Method)functionalMethod, (int)1)});
    }

    private static boolean isMulti(Type type) {
        return type.getTypeName().startsWith("reactor.util.function.Tuple");
    }

    private static void assertSupportedTypes(Type type) {
        Class candidateType;
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            Assert.isTrue((boolean)(type instanceof Class), (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
        }
        Assert.isTrue((Supplier.class.isAssignableFrom(candidateType = (Class)type) || Function.class.isAssignableFrom(candidateType) || Consumer.class.isAssignableFrom(candidateType) || FunctionRegistration.class.isAssignableFrom(candidateType) || type.getTypeName().startsWith("org.springframework.context.annotation.ConfigurationClassEnhancer") ? 1 : 0) != 0, (String)("Must be one of Supplier, Function, Consumer or FunctionRegistration. Was " + type));
    }

    private static Type extractReactiveType(Type type) {
        if (type instanceof ParameterizedType && FunctionRegistration.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) && (type = FunctionTypeUtils.getImmediateGenericType(type, 0)) instanceof ParameterizedType) {
            type = FunctionTypeUtils.getImmediateGenericType(type, 0);
        }
        return type;
    }
}

