/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.BeanFactoryAwareFunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.json.GsonMapper;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={FunctionCatalog.class})
public class ContextFunctionCatalogAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";

    @Bean
    public FunctionRegistry functionCatalog(Map<String, MessageConverter> messageConverters) {
        DefaultConversionService conversionService = new DefaultConversionService();
        CompositeMessageConverter messageConverter = null;
        ArrayList<Object> mcList = new ArrayList<Object>();
        boolean addDefaultConverters = true;
        if (!CollectionUtils.isEmpty(messageConverters)) {
            for (MessageConverter mc : messageConverters.values()) {
                if (mc instanceof CompositeMessageConverter) {
                    mcList.addAll(((CompositeMessageConverter)mc).getConverters());
                    addDefaultConverters = false;
                    continue;
                }
                mcList.add(mc);
            }
        }
        if (addDefaultConverters) {
            mcList.add(new MappingJackson2MessageConverter());
            mcList.add(new ByteArrayMessageConverter());
            mcList.add(new StringMessageConverter());
        }
        messageConverter = new CompositeMessageConverter(mcList);
        return new BeanFactoryAwareFunctionRegistry((ConversionService)conversionService, messageConverter);
    }

    @Bean(value={"router"})
    @ConditionalOnProperty(name={"spring.cloud.function.routing.enabled"}, havingValue="true")
    RoutingFunction gateway(FunctionCatalog functionCatalog, FunctionInspector functionInspector) {
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new MappingJackson2MessageConverter());
        messageConverters.add(new StringMessageConverter());
        messageConverters.add(new ByteArrayMessageConverter());
        CompositeMessageConverter messageConverter = new CompositeMessageConverter(messageConverters);
        return new RoutingFunction(functionCatalog, functionInspector, (MessageConverter)messageConverter);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    protected static class JacksonConfiguration {
        protected JacksonConfiguration() {
        }

        @Bean
        public JacksonMapper jsonMapper(ObjectMapper mapper) {
            return new JacksonMapper(mapper);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Gson.class})
    @ConditionalOnBean(value={Gson.class})
    @Conditional(value={PreferGsonOrMissingJacksonCondition.class})
    protected static class GsonConfiguration {
        protected GsonConfiguration() {
        }

        @Bean
        public GsonMapper jsonMapper(Gson gson) {
            return new GsonMapper(gson);
        }
    }

    private static class PreferGsonOrMissingJacksonCondition
    extends AnyNestedCondition {
        PreferGsonOrMissingJacksonCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={ObjectMapper.class})
        static class JacksonMissing {
            JacksonMissing() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="gson", matchIfMissing=false)
        static class GsonPreferred {
            GsonPreferred() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ComponentScan(basePackages={"${spring.cloud.function.scan.packages:functions}"}, includeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={Supplier.class, Function.class, Consumer.class})})
    @ConditionalOnProperty(prefix="spring.cloud.function.scan", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class PlainFunctionScanConfiguration {
        protected PlainFunctionScanConfiguration() {
        }
    }
}

