/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class BeanFactoryAwareFunctionRegistry
implements FunctionRegistry,
FunctionInspector,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(BeanFactoryAwareFunctionRegistry.class);
    private ConfigurableApplicationContext applicationContext;
    private final Map<Object, FunctionRegistration<Object>> registrationsByFunction = new HashMap<Object, FunctionRegistration<Object>>();
    private final Map<String, FunctionRegistration<Object>> registrationsByName = new HashMap<String, FunctionRegistration<Object>>();
    private final ConversionService conversionService;
    private final CompositeMessageConverter messageConverter;

    public BeanFactoryAwareFunctionRegistry(ConversionService conversionService, @Nullable CompositeMessageConverter messageConverter) {
        this.conversionService = conversionService;
        this.messageConverter = messageConverter;
    }

    @Override
    public <T> T lookup(Class<?> type, String definition) {
        return (T)this.compose(type, definition, new String[0]);
    }

    @Override
    public int size() {
        return this.applicationContext.getBeanNamesForType(Supplier.class).length + this.applicationContext.getBeanNamesForType(Function.class).length + this.applicationContext.getBeanNamesForType(Consumer.class).length;
    }

    @Override
    public <T> T lookup(String definition, String ... acceptedOutputTypes) {
        Assert.notEmpty((Object[])acceptedOutputTypes, (String)"'acceptedOutputTypes' must not be null or empty");
        return (T)this.compose(null, definition, acceptedOutputTypes);
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        Set<String> registeredNames = this.registrationsByFunction.values().stream().flatMap(reg -> reg.getNames().stream()).collect(Collectors.toSet());
        if (type == null) {
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(Function.class)));
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(Supplier.class)));
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(Consumer.class)));
        } else {
            registeredNames.addAll(CollectionUtils.arrayToList((Object)this.applicationContext.getBeanNamesForType(type)));
        }
        return registeredNames;
    }

    @Override
    public <T> void register(FunctionRegistration<T> registration) {
        this.registrationsByFunction.put(registration.getTarget(), registration);
        for (String name : registration.getNames()) {
            this.registrationsByName.put(name, registration);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    public FunctionRegistration<?> getRegistration(Object function) {
        FunctionRegistration<Object> registration = this.registrationsByFunction.get(function);
        if (registration == null && function instanceof FunctionInvocationWrapper) {
            function = ((FunctionInvocationWrapper)function).target;
        }
        return this.registrationsByFunction.get(function);
    }

    public FunctionType getFunctionType(String name) {
        return FunctionType.of(FunctionTypeUtils.getFunctionType(this.lookup(name), this));
    }

    private Object locateFunction(String name) {
        FunctionRegistration<Object> function = null;
        if (this.applicationContext.containsBean(name)) {
            function = this.applicationContext.getBean(name);
        }
        if (function == null) {
            function = this.registrationsByName.get(name);
        }
        return function;
    }

    private Type discoverFunctionType(Object function, String ... names) {
        boolean beanDefinitionExists = false;
        for (int i = 0; i < names.length && !beanDefinitionExists; ++i) {
            beanDefinitionExists = this.applicationContext.getBeanFactory().containsBeanDefinition(names[i]);
        }
        if (!beanDefinitionExists) {
            logger.info((Object)("BeanDefinition for function name(s) `" + Arrays.asList(names) + "` can not be located. FunctionType will be based on " + function.getClass()));
        }
        return beanDefinitionExists ? FunctionType.of(FunctionContextUtils.findType(this.applicationContext.getBeanFactory(), names)).getType() : new FunctionType(function.getClass()).getType();
    }

    private String discoverDefaultDefinitionIfNecessary(String definition) {
        if (StringUtils.isEmpty((Object)definition)) {
            Object[] functionNames = this.applicationContext.getBeanNamesForType(Function.class);
            if (!ObjectUtils.isEmpty((Object[])functionNames)) {
                Assert.isTrue((functionNames.length == 1 ? 1 : 0) != 0, (String)"Found more then one function in BeanFactory");
                definition = functionNames[0];
            } else if (this.registrationsByName.size() > 0) {
                Assert.isTrue((this.registrationsByName.size() == 1 ? 1 : 0) != 0, (String)"Found more then one function in local registry");
                definition = this.registrationsByName.keySet().iterator().next();
            }
        }
        return definition;
    }

    private Function<?, ?> compose(Class<?> type, String definition, String ... acceptedOutputTypes) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Looking up function '" + definition + "' with acceptedOutputTypes: " + Arrays.asList(acceptedOutputTypes)));
        }
        if (StringUtils.isEmpty((Object)(definition = this.discoverDefaultDefinitionIfNecessary(definition)))) {
            return null;
        }
        Function<Object, Object> resultFunction = null;
        if (this.registrationsByName.containsKey(definition)) {
            Object targetFunction = this.registrationsByName.get(definition).getTarget();
            Type functionType = this.registrationsByName.get(definition).getType().getType();
            resultFunction = new FunctionInvocationWrapper(targetFunction, functionType, definition, acceptedOutputTypes);
        } else {
            String[] names = StringUtils.delimitedListToStringArray((String)definition.replaceAll(",", "|").trim(), (String)"|");
            StringBuilder composedNameBuilder = new StringBuilder();
            String prefix = "";
            Type originFunctionType = null;
            for (String name : names) {
                FunctionRegistration<Object> registration;
                Object function = this.locateFunction(name);
                if (function == null) {
                    logger.warn((Object)("!!! Failed to discover function '" + definition + "' in function catalog. Function available in catalog are: " + this.getNames(null)));
                    return null;
                }
                composedNameBuilder.append(prefix);
                composedNameBuilder.append(name);
                Type currentFunctionType = null;
                if (function instanceof FunctionRegistration) {
                    registration = (FunctionRegistration<Object>)function;
                    currentFunctionType = registration.getType().getType();
                    function = registration.getTarget();
                } else {
                    String[] aliasNames = this.getAliases(name).toArray(new String[0]);
                    currentFunctionType = this.discoverFunctionType(function, aliasNames);
                    registration = new FunctionRegistration<Object>(function, name).type(currentFunctionType);
                }
                this.registrationsByFunction.putIfAbsent(function, registration);
                this.registrationsByName.putIfAbsent(name, registration);
                function = new FunctionInvocationWrapper(function, currentFunctionType, name, acceptedOutputTypes);
                if (originFunctionType == null) {
                    originFunctionType = currentFunctionType;
                }
                if (resultFunction == null) {
                    resultFunction = (Function)function;
                } else {
                    originFunctionType = FunctionTypeUtils.compose(originFunctionType, currentFunctionType);
                    resultFunction = new FunctionInvocationWrapper(resultFunction.andThen((Function)function), originFunctionType, composedNameBuilder.toString(), acceptedOutputTypes);
                }
                prefix = "|";
            }
            FunctionRegistration<FunctionInvocationWrapper> registration = new FunctionRegistration<FunctionInvocationWrapper>((FunctionInvocationWrapper)resultFunction, definition).type(originFunctionType);
            this.registrationsByFunction.putIfAbsent(resultFunction, registration);
            this.registrationsByName.putIfAbsent(definition, registration);
        }
        return resultFunction;
    }

    private Collection<String> getAliases(String key) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String value = this.getQualifier(key);
        if (value.equals(key) && this.applicationContext != null) {
            names.addAll(Arrays.asList(this.applicationContext.getBeanFactory().getAliases(key)));
        }
        names.add(value);
        return names;
    }

    private String getQualifier(String key) {
        StandardMethodMetadata metadata;
        Qualifier qualifier;
        BeanDefinition beanDefinition;
        Object source;
        if (this.applicationContext != null && this.applicationContext.getBeanFactory().containsBeanDefinition(key) && (source = (beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(key)).getSource()) instanceof StandardMethodMetadata && (qualifier = (Qualifier)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)(metadata = (StandardMethodMetadata)source).getIntrospectedMethod(), Qualifier.class)) != null && qualifier.value().length() > 0) {
            return qualifier.value();
        }
        return key;
    }

    public class FunctionInvocationWrapper
    implements Function<Object, Object>,
    Consumer<Object>,
    Supplier<Object> {
        private final Object target;
        private final Type functionType;
        private final boolean composed;
        private final String[] acceptedOutputMimeTypes;
        private final String functionDefinition;

        FunctionInvocationWrapper(Object target, Type functionType, String functionDefinition, String ... acceptedOutputMimeTypes) {
            this.target = target;
            this.composed = !target.getClass().getName().contains("EnhancerBySpringCGLIB") && target.getClass().getDeclaredFields().length > 1;
            this.functionType = functionType;
            this.acceptedOutputMimeTypes = acceptedOutputMimeTypes;
            this.functionDefinition = functionDefinition;
        }

        @Override
        public void accept(Object input) {
            this.doApply(input, true);
        }

        @Override
        public Object apply(Object input) {
            return this.doApply(input, false);
        }

        @Override
        public Object get() {
            Mono input = FunctionTypeUtils.isMono(this.functionType) ? Mono.empty() : (FunctionTypeUtils.isMono(this.functionType) ? Flux.empty() : null);
            return this.doApply(input, false);
        }

        public boolean isConsumer() {
            return this.target instanceof Consumer;
        }

        public boolean isFunction() {
            return this.target instanceof Function;
        }

        public boolean isSupplier() {
            return this.target instanceof Supplier;
        }

        public Object getTarget() {
            return this.target;
        }

        private Object invokeFunction(Object input) {
            Object invocationResult = null;
            if (this.target instanceof Function) {
                invocationResult = ((Function)this.target).apply(input);
            } else if (this.target instanceof Supplier) {
                invocationResult = ((Supplier)this.target).get();
            } else {
                ((Consumer)this.target).accept(input);
            }
            if (!(this.target instanceof Consumer) && logger.isDebugEnabled()) {
                logger.debug((Object)("Result of invocation of \"" + this.functionDefinition + "\" function is '" + invocationResult + "'"));
            }
            return invocationResult;
        }

        private Object doApply(Object input, boolean consumer) {
            Object result;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying function: " + this.functionDefinition));
            }
            if (input instanceof Publisher) {
                Publisher<?> publisher = input = this.composed ? input : this.convertInputPublisherIfNecessary((Publisher)input, FunctionTypeUtils.getInputType(this.functionType, 0));
                if (FunctionTypeUtils.isReactive(FunctionTypeUtils.getInputType(this.functionType, 0))) {
                    result = this.invokeFunction(input);
                    result = result == null ? Mono.empty() : result;
                } else {
                    if (this.composed) {
                        return input instanceof Mono ? Mono.from(input).transform((Function)this.target) : Flux.from(input).transform((Function)this.target);
                    }
                    result = FunctionTypeUtils.isConsumer(this.functionType) ? (input instanceof Mono ? Mono.from(input).doOnNext((Consumer)this.target).then() : Flux.from(input).doOnNext((Consumer)this.target).then()) : (input instanceof Mono ? Mono.from(input).map(value -> this.invokeFunction(value)) : Flux.from(input).map(value -> this.invokeFunction(value)));
                }
            } else {
                Type type = FunctionTypeUtils.getInputType(this.functionType, 0);
                if (!this.composed && !FunctionTypeUtils.isMultipleInputArguments(this.functionType) && FunctionTypeUtils.isReactive(type)) {
                    Flux publisher = FunctionTypeUtils.isFlux(type) ? (input == null ? Flux.empty() : Flux.just(input)) : (input == null ? Mono.empty() : Mono.just(input));
                    result = this.invokeFunction(this.convertInputPublisherIfNecessary((Publisher<?>)publisher, FunctionTypeUtils.getInputType(this.functionType, 0)));
                } else {
                    result = this.invokeFunction(this.composed ? input : this.convertInputValueIfNecessary(input, FunctionTypeUtils.getInputType(this.functionType, 0)));
                }
            }
            if (!ObjectUtils.isEmpty((Object[])this.acceptedOutputMimeTypes)) {
                result = result instanceof Publisher ? this.convertOutputPublisherIfNecessary((Publisher)result, this.acceptedOutputMimeTypes) : this.convertOutputValueIfNecessary(result, this.acceptedOutputMimeTypes);
            }
            return result;
        }

        private Object convertOutputValueIfNecessary(Object value, String ... acceptedOutputMimeTypes) {
            logger.debug((Object)"Applying type conversion on output value");
            Tuple2 convertedValue = null;
            if (FunctionTypeUtils.isMultipleArgumentsHolder(value)) {
                int outputCount = FunctionTypeUtils.getOutputCount(this.functionType);
                Object[] convertedInputArray = new Object[outputCount];
                for (int i = 0; i < outputCount; ++i) {
                    Expression parsed = new SpelExpressionParser().parseExpression("getT" + (i + 1) + "()");
                    Object outputArgument = parsed.getValue(value);
                    try {
                        convertedInputArray[i] = outputArgument instanceof Publisher ? this.convertOutputPublisherIfNecessary((Publisher)outputArgument, acceptedOutputMimeTypes[i]) : this.convertOutputValueIfNecessary(outputArgument, acceptedOutputMimeTypes);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IllegalStateException("The number of 'acceptedOutputMimeTypes' for function '" + this.functionDefinition + "' is (" + acceptedOutputMimeTypes.length + "), which does not match the number of actual outputs of this function which is (" + outputCount + ").", e);
                    }
                }
                convertedValue = Tuples.fromArray((Object[])convertedInputArray);
            } else {
                List acceptedContentTypes = MimeTypeUtils.parseMimeTypes((String)acceptedOutputMimeTypes[0].toString());
                convertedValue = acceptedContentTypes.stream().map(acceptedContentType -> BeanFactoryAwareFunctionRegistry.this.messageConverter.toMessage(value, new MessageHeaders(Collections.singletonMap("contentType", acceptedContentType)))).filter(v -> v != null).findFirst().orElse(null);
            }
            return convertedValue;
        }

        private Publisher<?> convertOutputPublisherIfNecessary(Publisher<?> publisher, String ... acceptedOutputMimeTypes) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying type conversion on output Publisher " + publisher));
            }
            Mono result = publisher instanceof Mono ? Mono.from(publisher).map(value -> this.convertOutputValueIfNecessary(value, acceptedOutputMimeTypes)) : Flux.from(publisher).map(value -> this.convertOutputValueIfNecessary(value, acceptedOutputMimeTypes));
            return result;
        }

        private Publisher<?> convertInputPublisherIfNecessary(Publisher<?> publisher, Type type) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying type conversion on input Publisher " + publisher));
            }
            Mono result = publisher instanceof Mono ? Mono.from(publisher).map(value -> this.convertInputValueIfNecessary(value, type)) : Flux.from(publisher).map(value -> this.convertInputValueIfNecessary(value, type));
            return result;
        }

        private Object convertInputValueIfNecessary(Object value, Type type) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying type conversion on input value " + value));
                logger.debug((Object)("Function type: " + this.functionType));
            }
            Object convertedValue = value;
            if (FunctionTypeUtils.isMultipleArgumentsHolder(value)) {
                int inputCount = FunctionTypeUtils.getInputCount(this.functionType);
                Object[] convertedInputArray = new Object[inputCount];
                for (int i = 0; i < inputCount; ++i) {
                    Expression parsed = new SpelExpressionParser().parseExpression("getT" + (i + 1) + "()");
                    Publisher<?> inptArgument = parsed.getValue(value);
                    convertedInputArray[i] = inptArgument = inptArgument instanceof Publisher ? this.convertInputPublisherIfNecessary((Publisher)inptArgument, FunctionTypeUtils.getInputType(this.functionType, i)) : this.convertInputValueIfNecessary(inptArgument, FunctionTypeUtils.getInputType(this.functionType, i));
                }
                convertedValue = Tuples.fromArray((Object[])convertedInputArray);
            } else {
                Type rawType = FunctionTypeUtils.unwrapActualTypeByIndex(type, 0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Raw type of value: " + value + "is " + rawType));
                }
                if (rawType instanceof ParameterizedType) {
                    rawType = ((ParameterizedType)rawType).getRawType();
                }
                if (value instanceof Message) {
                    if (this.messageNeedsConversion(rawType, (Message)value)) {
                        Object object = convertedValue = FunctionTypeUtils.isTypeCollection(type) ? BeanFactoryAwareFunctionRegistry.this.messageConverter.fromMessage((Message)value, (Class)rawType, (Object)type) : BeanFactoryAwareFunctionRegistry.this.messageConverter.fromMessage((Message)value, (Class)rawType);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Converted from Message: " + convertedValue));
                        }
                        if (FunctionTypeUtils.isMessage(type)) {
                            convertedValue = MessageBuilder.withPayload((Object)convertedValue).copyHeaders((Map)((Message)value).getHeaders()).build();
                        }
                    } else if (!FunctionTypeUtils.isMessage(type)) {
                        convertedValue = ((Message)convertedValue).getPayload();
                    }
                } else if (rawType instanceof Class) {
                    convertedValue = BeanFactoryAwareFunctionRegistry.this.conversionService.convert(value, (Class)rawType);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted input value " + convertedValue));
            }
            return convertedValue;
        }

        private boolean messageNeedsConversion(Type rawType, Message<?> message) {
            return rawType instanceof Class && !(message.getPayload() instanceof Optional) && !message.getPayload().getClass().isAssignableFrom((Class)rawType);
        }
    }
}

