/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.tools.JavaFileObject;
import org.springframework.cloud.function.compiler.java.CloseableFilterableJavaFileObjectIterable;
import org.springframework.cloud.function.compiler.java.JrtEntryJavaFileObject;
import org.springframework.cloud.function.compiler.java.JrtFsEnumeration;
import org.springframework.cloud.function.compiler.java.MemoryBasedJavaFileManager;

public class IterableJrtModule
extends CloseableFilterableJavaFileObjectIterable {
    Map<String, JrtFsEnumeration> walkers = new HashMap<String, JrtFsEnumeration>();
    private Path moduleRootPath;

    public IterableJrtModule(MemoryBasedJavaFileManager.CompilationInfoCache compilationInfoCache, Path moduleRootPath, String packageNameFilter, boolean includeSubpackages) {
        super(compilationInfoCache, packageNameFilter, includeSubpackages);
        this.moduleRootPath = moduleRootPath;
    }

    @Override
    public Iterator<JavaFileObject> iterator() {
        JrtFsEnumeration jrtFsWalker = this.walkers.get(this.moduleRootPath.toString());
        if (jrtFsWalker == null) {
            jrtFsWalker = new JrtFsEnumeration(null, this.moduleRootPath);
            this.walkers.put(this.moduleRootPath.toString(), jrtFsWalker);
        }
        jrtFsWalker.reset();
        return new IteratorOverJrtFsEnumeration(jrtFsWalker);
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
        this.close();
    }

    class IteratorOverJrtFsEnumeration
    implements Iterator<JavaFileObject> {
        private JavaFileObject nextEntry = null;
        private JrtFsEnumeration jrtEnumeration;

        IteratorOverJrtFsEnumeration(JrtFsEnumeration jrtFsWalker) {
            this.jrtEnumeration = jrtFsWalker;
        }

        private void findNext() {
            if (this.nextEntry == null) {
                while (this.jrtEnumeration.hasMoreElements()) {
                    JrtEntryJavaFileObject jrtEntry = this.jrtEnumeration.nextElement();
                    String name = this.jrtEnumeration.getName(jrtEntry);
                    if (!IterableJrtModule.this.accept(name)) continue;
                    this.nextEntry = jrtEntry;
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.nextEntry != null;
        }

        @Override
        public JavaFileObject next() {
            this.findNext();
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            JavaFileObject retval = this.nextEntry;
            this.nextEntry = null;
            return retval;
        }
    }
}

