/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class JrtEntryJavaFileObject
implements JavaFileObject {
    private String pathToClassString;
    private Path path;

    public JrtEntryJavaFileObject(Path path) {
        this.pathToClassString = path.subpath(2, path.getNameCount()).toString();
        this.path = path;
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public String getName() {
        return this.pathToClassString;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        byte[] bytes = Files.readAllBytes(this.path);
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new IllegalStateException("Only expected to be used for input");
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("openReader() not supported on class file: " + this.getName());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("getCharContent() not supported on class file: " + this.getName());
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new IllegalStateException("only expected to be used for input");
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to determine last modified time of " + this.pathToClassString, ioe);
        }
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.CLASS) {
            return false;
        }
        String name = this.getName();
        int lastSlash = name.lastIndexOf(47);
        return name.substring(lastSlash + 1).equals(simpleName + ".class");
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JrtEntryJavaFileObject)) {
            return false;
        }
        JrtEntryJavaFileObject that = (JrtEntryJavaFileObject)obj;
        return this.getName().equals(that.getName());
    }

    public String getPathToClassString() {
        return this.pathToClassString;
    }
}

