/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.function.compiler.ConsumerCompiler;
import org.springframework.cloud.function.compiler.FunctionCompiler;
import org.springframework.cloud.function.compiler.SupplierCompiler;
import org.springframework.cloud.function.compiler.proxy.ByteCodeLoadingConsumer;
import org.springframework.cloud.function.compiler.proxy.ByteCodeLoadingFunction;
import org.springframework.cloud.function.compiler.proxy.ByteCodeLoadingSupplier;
import org.springframework.cloud.function.compiler.proxy.LambdaCompilingConsumer;
import org.springframework.cloud.function.compiler.proxy.LambdaCompilingFunction;
import org.springframework.cloud.function.compiler.proxy.LambdaCompilingSupplier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.cloud.function")
public class FunctionProxyApplicationListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private final SupplierCompiler<?> supplierCompiler = new SupplierCompiler();
    private final FunctionCompiler<?, ?> functionCompiler = new FunctionCompiler();
    private final ConsumerCompiler<?> consumerCompiler = new ConsumerCompiler();
    private final Map<String, Object> compile = new HashMap<String, Object>();
    private final Map<String, Object> imports = new HashMap<String, Object>();

    public Map<String, Object> getCompile() {
        return this.compile;
    }

    public Map<String, Object> getImports() {
        return this.imports;
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        String type;
        Map properties;
        String name;
        ConfigurableApplicationContext context = event.getApplicationContext();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
        this.bind(context);
        for (Map.Entry<String, Object> entry : this.compile.entrySet()) {
            name = entry.getKey();
            properties = (Map)entry.getValue();
            type = properties.get("type") != null ? (String)properties.get("type") : "function";
            String lambda = (String)properties.get("lambda");
            Assert.notNull((Object)lambda, (String)String.format("The 'lambda' property is required for compiling Function: %s", name));
            String inputType = (String)properties.get("inputType");
            String outputType = (String)properties.get("outputType");
            this.registerLambdaCompilingProxy(name, type, inputType, outputType, lambda, beanFactory);
        }
        for (Map.Entry<String, Object> entry : this.imports.entrySet()) {
            name = entry.getKey();
            properties = (Map)entry.getValue();
            type = properties.get("type") != null ? (String)properties.get("type") : "function";
            String location = (String)properties.get("location");
            Assert.notNull((Object)location, (String)String.format("The 'location' property is required for importing Function: %s", name));
            this.registerByteCodeLoadingProxy(name, type, context.getResource(location), beanFactory);
        }
    }

    private void bind(ConfigurableApplicationContext context) {
        ConfigurationPropertiesBindingPostProcessor post = new ConfigurationPropertiesBindingPostProcessor();
        this.maybeSetBeanFactory(context, post);
        try {
            post.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot bind properties", e);
        }
        post.postProcessBeforeInitialization((Object)this, this.getClass().getName());
    }

    private void maybeSetBeanFactory(ConfigurableApplicationContext context, ConfigurationPropertiesBindingPostProcessor post) {
        StaticApplicationContext other = new StaticApplicationContext();
        other.setEnvironment(context.getEnvironment());
        other.registerSingleton(ConfigurationBeanFactoryMetadata.class.getName(), ConfigurationBeanFactoryMetadata.class);
        other.setParent((ApplicationContext)context);
        post.setApplicationContext((ApplicationContext)other);
    }

    private void registerByteCodeLoadingProxy(String name, String type, Resource resource, DefaultListableBeanFactory beanFactory) {
        Class proxyClass = null;
        proxyClass = "supplier".equals(type.toLowerCase()) ? ByteCodeLoadingSupplier.class : ("consumer".equals(type.toLowerCase()) ? ByteCodeLoadingConsumer.class : ByteCodeLoadingFunction.class);
        RootBeanDefinition beanDefinition = new RootBeanDefinition(proxyClass);
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue((Object)resource);
        beanDefinition.setConstructorArgumentValues(args);
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }

    private void registerLambdaCompilingProxy(String name, String type, String inputType, String outputType, String lambda, DefaultListableBeanFactory beanFactory) {
        ByteArrayResource resource = new ByteArrayResource(lambda.getBytes());
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        MutablePropertyValues props = new MutablePropertyValues();
        args.addGenericArgumentValue((Object)resource);
        Class proxyClass = null;
        if ("supplier".equals(type.toLowerCase())) {
            proxyClass = LambdaCompilingSupplier.class;
            args.addGenericArgumentValue(this.supplierCompiler);
            if (outputType != null) {
                props.add("typeParameterizations", (Object)outputType);
            }
        } else if ("consumer".equals(type.toLowerCase())) {
            proxyClass = LambdaCompilingConsumer.class;
            args.addGenericArgumentValue(this.consumerCompiler);
            if (inputType != null) {
                props.add("typeParameterizations", (Object)inputType);
            }
        } else {
            proxyClass = LambdaCompilingFunction.class;
            args.addGenericArgumentValue(this.functionCompiler);
            if (inputType == null && outputType != null || outputType == null && inputType != null) {
                throw new IllegalArgumentException("if either input or output type is set, the other is also required");
            }
            if (inputType != null) {
                props.add("typeParameterizations", (Object)new String[]{inputType, outputType});
            }
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(proxyClass);
        beanDefinition.setConstructorArgumentValues(args);
        beanDefinition.setPropertyValues(props);
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }
}

