/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.function.compiler.java.CloseableFilterableJavaFileObjectIterable;
import org.springframework.cloud.function.compiler.java.CompilationMessage;
import org.springframework.cloud.function.compiler.java.CompilationOutputCollector;
import org.springframework.cloud.function.compiler.java.CompiledClassDefinition;
import org.springframework.cloud.function.compiler.java.DependencyResolver;
import org.springframework.cloud.function.compiler.java.InMemoryJavaFileObject;
import org.springframework.cloud.function.compiler.java.IterableClasspath;
import org.springframework.cloud.function.compiler.java.IterableJrtModule;

public class MemoryBasedJavaFileManager
implements JavaFileManager {
    static final String BOOT_PACKAGING_PREFIX_FOR_CLASSES = "BOOT-INF/classes/";
    static final String BOOT_PACKAGING_PREFIX_FOR_LIBRARIES = "BOOT-INF/lib/";
    private static Logger logger = LoggerFactory.getLogger(MemoryBasedJavaFileManager.class);
    private CompilationOutputCollector outputCollector;
    private Map<String, File> resolvedAdditionalDependencies = new LinkedHashMap<String, File>();
    private String platformClasspath;
    private String classpath;
    private CompilationInfoCache compilationInfoCache;
    private Map<Key, CloseableFilterableJavaFileObjectIterable> iterables = new HashMap<Key, CloseableFilterableJavaFileObjectIterable>();
    private static URI JRT_URI = URI.create("jrt:/");
    private static FileSystem fs;
    private String jrtFsFilePath = null;
    private boolean checkedForJrtFsPath = false;

    public MemoryBasedJavaFileManager() {
        this.outputCollector = new CompilationOutputCollector();
        this.compilationInfoCache = new CompilationInfoCache();
    }

    @Override
    public int isSupportedOption(String option) {
        logger.debug("isSupportedOption({})", (Object)option);
        return -1;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        logger.debug("getClassLoader({})", (Object)location);
        return null;
    }

    private String getPlatformClassPath() {
        if (this.platformClasspath == null) {
            this.platformClasspath = System.getProperty("sun.boot.class.path");
        }
        if (this.platformClasspath == null) {
            this.platformClasspath = "";
        }
        return this.platformClasspath;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        logger.debug("list({},{},{},{})", new Object[]{location, packageName, kinds, recurse});
        String classpath = "";
        Path moduleRootPath = null;
        if (location instanceof JDKModuleLocation && (kinds == null || kinds.contains((Object)JavaFileObject.Kind.CLASS))) {
            moduleRootPath = ((JDKModuleLocation)location).getModuleRootPath();
            logger.debug("For JDKModuleLocation " + location.toString() + " root path is " + moduleRootPath);
        } else if (location == StandardLocation.PLATFORM_CLASS_PATH && (kinds == null || kinds.contains((Object)JavaFileObject.Kind.CLASS))) {
            classpath = this.getPlatformClassPath();
            logger.debug("Creating iterable for boot class path: {}", (Object)classpath);
        } else if (location == StandardLocation.CLASS_PATH && (kinds == null || kinds.contains((Object)JavaFileObject.Kind.CLASS))) {
            String javaClassPath = this.getClassPath();
            if (!this.resolvedAdditionalDependencies.isEmpty()) {
                for (File resolvedAdditionalDependency : this.resolvedAdditionalDependencies.values()) {
                    javaClassPath = javaClassPath + File.pathSeparatorChar + resolvedAdditionalDependency.toURI().toString().substring("file:".length());
                }
            }
            classpath = javaClassPath;
            logger.debug("Creating iterable for class path: {}", (Object)classpath);
        }
        Key k = new Key(location, classpath, packageName, kinds, recurse);
        CloseableFilterableJavaFileObjectIterable resultIterable = this.iterables.get(k);
        if (resultIterable == null) {
            resultIterable = moduleRootPath != null ? new IterableJrtModule(this.compilationInfoCache, moduleRootPath, packageName, recurse) : new IterableClasspath(this.compilationInfoCache, classpath, packageName, recurse);
            this.iterables.put(k, resultIterable);
        }
        resultIterable.reset();
        return resultIterable;
    }

    private String getClassPath() {
        if (this.classpath == null) {
            URL[] urls;
            ClassLoader loader = InMemoryJavaFileObject.class.getClassLoader();
            String cp = null;
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()).length > 1 && !urls[0].toString().startsWith("jar:file:")) {
                StringBuilder builder = new StringBuilder();
                for (URL url : urls) {
                    String path;
                    if (builder.length() > 0) {
                        builder.append(File.pathSeparator);
                    }
                    if ((path = url.toString()).startsWith("file:")) {
                        path = path.substring("file:".length());
                    }
                    builder.append(path);
                }
                cp = builder.toString();
            }
            if (cp == null) {
                cp = System.getProperty("java.class.path");
            }
            if (this.hasJrtFsPath()) {
                cp = cp + File.pathSeparator + this.getJrtFsPath();
            }
            this.classpath = this.pathWithPlatformClassPathRemoved(cp);
        }
        return this.classpath;
    }

    private String pathWithPlatformClassPathRemoved(String classpath) {
        Set<String> pcps = this.toList(this.getPlatformClassPath());
        Set<String> cps = this.toList(classpath);
        cps.removeAll(pcps);
        StringBuilder builder = new StringBuilder();
        for (String cpe : cps) {
            if (builder.length() > 0) {
                builder.append(File.pathSeparator);
            }
            builder.append(cpe);
        }
        return builder.toString();
    }

    private Set<String> toList(String path) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        logger.debug("hasLocation({})", (Object)location);
        return location == StandardLocation.SOURCE_PATH || location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.SOURCE_PATH) {
            return null;
        }
        String classname = file.getName().replace('/', '.').replace('\\', '.');
        return classname.substring(0, classname.lastIndexOf(".class"));
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        logger.debug("isSameFile({},{})", (Object)a, (Object)b);
        return a.equals(b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        logger.debug("handleOption({},{})", (Object)current, remaining);
        return false;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        logger.debug("getJavaFileForInput({},{},{})", new Object[]{location, className, kind});
        if (className.equals("module-info")) {
            return null;
        }
        throw new IllegalStateException("Not expected to be used in this context");
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        logger.debug("getJavaFileForOutput({},{},{},{})", new Object[]{location, className, kind, sibling});
        return this.outputCollector.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        logger.debug("getFileForInput({},{},{})", new Object[]{location, packageName, relativeName});
        throw new IllegalStateException("Not expected to be used in this context");
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        logger.debug("getFileForOutput({},{},{},{})", new Object[]{location, packageName, relativeName, sibling});
        return this.outputCollector.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        Collection<CloseableFilterableJavaFileObjectIterable> toClose = this.iterables.values();
        for (CloseableFilterableJavaFileObjectIterable icp : toClose) {
            icp.close();
        }
    }

    public List<CompiledClassDefinition> getCompiledClasses() {
        return this.outputCollector.getCompiledClasses();
    }

    public List<CompilationMessage> addAndResolveDependencies(String[] dependencies) {
        ArrayList<CompilationMessage> resolutionMessages = new ArrayList<CompilationMessage>();
        for (String dependency : dependencies) {
            if (dependency.startsWith("maven:")) {
                String coordinates = dependency.replaceFirst("maven:\\/*", "");
                DependencyResolver engine = DependencyResolver.instance();
                try {
                    File resolved = engine.resolve(new Dependency((Artifact)new DefaultArtifact(coordinates), "runtime"));
                    this.resolvedAdditionalDependencies.put(dependency, resolved);
                }
                catch (RuntimeException re) {
                    CompilationMessage compilationMessage = new CompilationMessage(CompilationMessage.Kind.ERROR, re.getMessage(), null, 0, 0);
                    resolutionMessages.add(compilationMessage);
                }
                continue;
            }
            if (dependency.startsWith("file:")) {
                this.resolvedAdditionalDependencies.put(dependency, new File(URI.create(dependency)));
                continue;
            }
            resolutionMessages.add(new CompilationMessage(CompilationMessage.Kind.ERROR, "Unrecognized dependency: " + dependency + " (expected something of the form: maven://groupId:artifactId:version)", null, 0, 0));
        }
        return resolutionMessages;
    }

    public Map<String, File> getResolvedAdditionalDependencies() {
        return this.resolvedAdditionalDependencies;
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        if (location instanceof JDKModuleLocation) {
            JDKModuleLocation m = (JDKModuleLocation)location;
            return m.getModuleName();
        }
        throw new IllegalStateException("Asked to inferModuleName from a " + location.getClass().getName());
    }

    private boolean hasJrtFsPath() {
        return this.getJrtFsPath() != null;
    }

    private String getJrtFsPath() {
        if (!this.checkedForJrtFsPath) {
            String javaHome = System.getProperty("java.home");
            String jrtFsFilePath = javaHome + File.separator + "lib" + File.separator + "jrt-fs.jar";
            File jrtFsFile = new File(jrtFsFilePath);
            if (jrtFsFile.exists()) {
                this.jrtFsFilePath = jrtFsFilePath;
            }
            this.checkedForJrtFsPath = true;
        }
        return this.jrtFsFilePath;
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        if (this.getJrtFsPath() != null && location == StandardLocation.valueOf("SYSTEM_MODULES")) {
            HashSet<Set<JavaFileManager.Location>> ss = new HashSet<Set<JavaFileManager.Location>>();
            HashSet<JavaFileManager.Location> moduleLocations = new HashSet<JavaFileManager.Location>();
            ModuleIdentifierVisitor visitor = new ModuleIdentifierVisitor();
            Iterable<Path> roots = MemoryBasedJavaFileManager.getJrtFs().getRootDirectories();
            try {
                for (Path path : roots) {
                    Files.walkFileTree(path, visitor);
                }
                moduleLocations.addAll(visitor.getModuleLocations());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ss.add(moduleLocations);
            return ss;
        }
        return Collections.emptySet();
    }

    private static FileSystem getJrtFs() {
        if (fs == null) {
            fs = FileSystems.getFileSystem(JRT_URI);
        }
        return fs;
    }

    static class ModuleIdentifierVisitor
    extends SimpleFileVisitor<Path> {
        private Map<String, Path> modules = new HashMap<String, Path>();

        ModuleIdentifierVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getNameCount() > 2 && file.toString().endsWith(".class")) {
                String moduleName = file.getName(1).toString();
                Path moduleRootPath = file.subpath(0, 2);
                if (!this.modules.containsKey(moduleName)) {
                    this.modules.put(moduleName, moduleRootPath);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        public Set<JavaFileManager.Location> getModuleLocations() {
            if (this.modules.size() == 0) {
                return Collections.emptySet();
            }
            HashSet<JavaFileManager.Location> locations = new HashSet<JavaFileManager.Location>();
            for (Map.Entry<String, Path> moduleEntry : this.modules.entrySet()) {
                locations.add(new JDKModuleLocation(moduleEntry.getKey(), moduleEntry.getValue()));
            }
            return locations;
        }
    }

    static class JDKModuleLocation
    implements JavaFileManager.Location {
        private String moduleName;
        private Path moduleRootPath;

        public JDKModuleLocation(String moduleName, Path moduleRootPath) {
            this.moduleName = moduleName;
            this.moduleRootPath = moduleRootPath;
        }

        @Override
        public String getName() {
            return "MODULE";
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public Path getModuleRootPath() {
            return this.moduleRootPath;
        }

        public String toString() {
            return "JDKModuleLocation(" + this.moduleName + ")";
        }

        public int hashCode() {
            return this.moduleName.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof JDKModuleLocation)) {
                return false;
            }
            return this.hashCode() == ((JDKModuleLocation)other).hashCode();
        }
    }

    static class Key {
        private JavaFileManager.Location location;
        private String classpath;
        private String packageName;
        private Set<JavaFileObject.Kind> kinds;
        private boolean recurse;

        public Key(JavaFileManager.Location location, String classpath, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) {
            this.location = location;
            this.classpath = classpath;
            this.packageName = packageName;
            this.kinds = kinds;
            this.recurse = recurse;
        }

        public int hashCode() {
            return ((this.location.hashCode() * 37 + this.classpath.hashCode() * 37 + (this.packageName == null ? 0 : this.packageName.hashCode())) * 37 + this.kinds.hashCode()) * 37 + (this.recurse ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.location.equals(that.location) && this.classpath.equals(that.classpath) && this.kinds.equals(that.kinds) && this.recurse == that.recurse && (this.packageName == null ? that.packageName == null : this.packageName.equals(that.packageName));
        }
    }

    static class CompilationInfoCache {
        private Map<File, ArchiveInfo> archivePackageCache;
        private boolean packageCacheInitialized = false;
        private Map<String, Path> packageCache = new HashMap<String, Path>();
        private ArchiveInfo moduleArchiveInfo;

        CompilationInfoCache() {
        }

        ArchiveInfo getArchiveInfoFor(File archive) {
            if (!archive.isFile() || !archive.getName().endsWith(".zip") && !archive.getName().endsWith(".jar")) {
                return null;
            }
            if (this.archivePackageCache == null) {
                this.archivePackageCache = new HashMap<File, ArchiveInfo>();
            }
            try {
                ArchiveInfo result = this.archivePackageCache.get(archive);
                if (result == null) {
                    result = this.buildArchiveInfo(archive);
                    this.archivePackageCache.put(archive, result);
                }
                return result;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected problem caching entries from " + archive.getName(), e);
            }
        }

        private synchronized ArchiveInfo buildPackageMap() {
            if (!this.packageCacheInitialized) {
                this.packageCacheInitialized = true;
                Iterable<Path> roots = MemoryBasedJavaFileManager.getJrtFs().getRootDirectories();
                PackageCacheBuilderVisitor visitor = new PackageCacheBuilderVisitor();
                try {
                    for (Path path : roots) {
                        Files.walkFileTree(path, visitor);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ArrayList<String> ls = new ArrayList<String>();
                ls.addAll(this.packageCache.keySet());
                Collections.sort(ls);
                this.moduleArchiveInfo = new ArchiveInfo(ls, false);
            }
            return this.moduleArchiveInfo;
        }

        private ArchiveInfo buildArchiveInfo(File file) {
            if (file.toString().endsWith("jrt-fs.jar")) {
                return this.buildPackageMap();
            }
            ArrayList<String> packageNames = new ArrayList<String>();
            boolean isBootJar = false;
            try (ZipFile openArchive = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = openArchive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.endsWith(".class")) {
                        int idx;
                        if (name.startsWith(MemoryBasedJavaFileManager.BOOT_PACKAGING_PREFIX_FOR_CLASSES)) {
                            isBootJar = true;
                            idx = name.lastIndexOf(47) + 1;
                            if (idx == 0) continue;
                            if (idx == MemoryBasedJavaFileManager.BOOT_PACKAGING_PREFIX_FOR_CLASSES.length()) {
                                packageNames.add("/");
                                continue;
                            }
                            name = name.substring(MemoryBasedJavaFileManager.BOOT_PACKAGING_PREFIX_FOR_CLASSES.length(), idx);
                            name = name.replace('\\', '/');
                            packageNames.add(name);
                            continue;
                        }
                        idx = name.lastIndexOf(47) + 1;
                        if (idx != 0) {
                            name = name.replace('\\', '/');
                            name = name.substring(0, idx);
                            packageNames.add(name);
                            continue;
                        }
                        if (idx != 0) continue;
                        packageNames.add("/");
                        continue;
                    }
                    if (!name.startsWith(MemoryBasedJavaFileManager.BOOT_PACKAGING_PREFIX_FOR_LIBRARIES) || !name.endsWith(".jar")) continue;
                    isBootJar = true;
                    ZipInputStream zis = new ZipInputStream(openArchive.getInputStream(entry));
                    Throwable throwable = null;
                    try {
                        IterableClasspath.ZipEnumerator nestedZipEnumerator = new IterableClasspath.ZipEnumerator(zis);
                        while (nestedZipEnumerator.hasMoreElements()) {
                            ZipEntry innerEntry = (ZipEntry)nestedZipEnumerator.nextElement();
                            String innerEntryName = innerEntry.getName();
                            if (!innerEntryName.endsWith(".class")) continue;
                            int idx = innerEntryName.lastIndexOf(47) + 1;
                            if (idx != 0) {
                                innerEntryName = innerEntryName.replace('\\', '/');
                                innerEntryName = innerEntryName.substring(0, idx);
                                packageNames.add(innerEntryName);
                                continue;
                            }
                            if (idx != 0) continue;
                            packageNames.add("/");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zis == null) continue;
                        if (throwable != null) {
                            try {
                                zis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        zis.close();
                    }
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unexpected problem determining packages in " + file, ioe);
            }
            return new ArchiveInfo(packageNames, isBootJar);
        }

        private class PackageCacheBuilderVisitor
        extends SimpleFileVisitor<Path> {
            private PackageCacheBuilderVisitor() {
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                int fnc;
                if (file.getNameCount() > 3 && file.toString().endsWith(".class") && (fnc = file.getNameCount()) > 3) {
                    Path packagePath = file.subpath(2, fnc - 1);
                    String packagePathString = packagePath.toString() + "/";
                    CompilationInfoCache.this.packageCache.put(packagePathString, file.subpath(0, fnc - 1));
                }
                return FileVisitResult.CONTINUE;
            }
        }

        static class ArchiveInfo {
            private List<String> packageNames;
            private boolean isBootJar = false;

            public ArchiveInfo(List<String> packageNames, boolean isBootJar) {
                this.packageNames = packageNames;
                Collections.sort(this.packageNames);
                this.isBootJar = isBootJar;
            }

            public List<String> getPackageNames() {
                return this.packageNames;
            }

            public boolean isBootJar() {
                return this.isBootJar;
            }

            public boolean containsPackage(String packageName, boolean subpackageMatchesAllowed) {
                if (subpackageMatchesAllowed) {
                    for (String candidatePackageName : this.packageNames) {
                        if (!candidatePackageName.startsWith(packageName)) continue;
                        return true;
                    }
                    return false;
                }
                int pos = Collections.binarySearch(this.packageNames, packageName);
                return pos >= 0;
            }
        }
    }
}

