/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.yarn.boot.actuate.endpoint.mvc.AbstractContainerClusterRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterCreateRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterModifyRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.ContainerClusterResource;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.YarnContainerClusterEndpointResource;
import org.springframework.yarn.boot.app.YarnContainerClusterClientException;
import org.springframework.yarn.boot.app.YarnContainerClusterOperations;
import org.springframework.yarn.boot.app.YarnContainerClusterTemplate;
import org.springframework.yarn.boot.properties.SpringYarnProperties;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.client.ApplicationDescriptor;
import org.springframework.yarn.client.ApplicationYarnClient;
import org.springframework.yarn.client.YarnClient;
import org.springframework.yarn.support.console.ContainerClusterReport;

public class YarnCloudAppServiceApplication
implements InitializingBean,
DisposableBean {
    private ConfigurableApplicationContext context;
    private ApplicationContextInitializer<?>[] initializers;
    private List<Object> sources = new ArrayList<Object>();
    private List<String> profiles = new ArrayList<String>();
    private Properties appProperties = new Properties();
    private Map<String, Properties> configFilesContents = new HashMap<String, Properties>();
    private String[] args = new String[0];
    private final HashMap<String, YarnContainerClusterOperations> operationsCache = new HashMap();
    private ApplicationYarnClient yarnClient;
    private SpringYarnProperties springYarnProperties;
    private RestTemplate restTemplate;

    public YarnCloudAppServiceApplication(String applicationVersion, String deployerVersion, String configFileName, Properties configFileProperties, String[] runArgs, ApplicationContextInitializer<?> ... initializers) {
        if (StringUtils.hasText((String)applicationVersion)) {
            this.appProperties.setProperty("spring.yarn.applicationVersion", applicationVersion);
        }
        if (StringUtils.hasText((String)deployerVersion)) {
            this.appProperties.setProperty("spring.cloud.deployer.yarn.version", deployerVersion);
        }
        if (StringUtils.hasText((String)configFileName) && configFileProperties != null) {
            this.configFilesContents.put(configFileName, configFileProperties);
        }
        if (runArgs != null) {
            this.args = runArgs;
        }
        this.initializers = initializers;
    }

    public void afterPropertiesSet() throws Exception {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]);
        builder.web(false);
        builder.sources(new Class[]{Config.class});
        SpringYarnBootUtils.addSources((SpringApplicationBuilder)builder, (Object[])this.sources.toArray(new Object[0]));
        SpringYarnBootUtils.addProfiles((SpringApplicationBuilder)builder, (String[])this.profiles.toArray(new String[0]));
        SpringYarnBootUtils.addApplicationListener((SpringApplicationBuilder)builder, (Properties)this.appProperties);
        if (this.initializers != null) {
            builder.initializers(this.initializers);
        }
        SpringYarnBootUtils.addConfigFilesContents((SpringApplicationBuilder)builder, this.configFilesContents);
        this.context = builder.run(this.args);
        YarnClient client = (YarnClient)this.context.getBean(YarnClient.class);
        if (!(client instanceof ApplicationYarnClient)) {
            throw new IllegalArgumentException("YarnClient need to be instanceof ApplicationYarnClient");
        }
        this.yarnClient = (ApplicationYarnClient)client;
        this.restTemplate = (RestTemplate)this.context.getBean("yarnRestTemplate", RestTemplate.class);
        this.springYarnProperties = (SpringYarnProperties)this.context.getBean(SpringYarnProperties.class);
    }

    public void destroy() throws Exception {
        if (this.context != null) {
            this.context.close();
        }
        this.context = null;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public Collection<YarnCloudAppService.CloudAppInfo> getPushedApplications() {
        ArrayList<YarnCloudAppService.CloudAppInfo> apps = new ArrayList<YarnCloudAppService.CloudAppInfo>();
        YarnConfiguration yarnConfiguration = (YarnConfiguration)this.context.getBean("yarnConfiguration", YarnConfiguration.class);
        SpringYarnProperties springYarnProperties = (SpringYarnProperties)this.context.getBean(SpringYarnProperties.class);
        String applicationBaseDir = springYarnProperties.getApplicationBaseDir();
        Path path = new Path(applicationBaseDir);
        try {
            FileSystem fs = path.getFileSystem((Configuration)yarnConfiguration);
            FileStatus[] listStatus = new FileStatus[]{};
            if (fs.exists(path)) {
                listStatus = fs.listStatus(path);
            }
            for (FileStatus status : listStatus) {
                apps.add(new YarnCloudAppService.CloudAppInfo(status.getPath().getName()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return apps;
    }

    public Collection<YarnCloudAppService.CloudAppInstanceInfo> getSubmittedApplications() {
        ArrayList<YarnCloudAppService.CloudAppInstanceInfo> appIds = new ArrayList<YarnCloudAppService.CloudAppInstanceInfo>();
        for (ApplicationReport report : this.yarnClient.listApplications("DATAFLOW")) {
            appIds.add(new YarnCloudAppService.CloudAppInstanceInfo(report.getApplicationId().toString(), report.getName(), report.getYarnApplicationState().toString(), report.getOriginalTrackingUrl()));
        }
        return appIds;
    }

    public Collection<YarnCloudAppService.CloudAppInstanceInfo> getSubmittedApplications(String yarnApplicationId) {
        ArrayList<YarnCloudAppService.CloudAppInstanceInfo> appIds = new ArrayList<YarnCloudAppService.CloudAppInstanceInfo>();
        for (ApplicationReport report : this.yarnClient.listApplications("DATAFLOW")) {
            if (!report.getApplicationId().toString().equals(yarnApplicationId)) continue;
            appIds.add(new YarnCloudAppService.CloudAppInstanceInfo(report.getApplicationId().toString(), report.getName(), report.getYarnApplicationState().toString(), report.getOriginalTrackingUrl()));
        }
        return appIds;
    }

    public void pushApplication(String applicationName) {
        this.yarnClient.installApplication(new ApplicationDescriptor(YarnCloudAppServiceApplication.resolveApplicationdir(this.springYarnProperties, applicationName)));
    }

    public String submitApplication(String applicationName) {
        ApplicationId appId = null;
        appId = this.yarnClient.submitApplication(new ApplicationDescriptor(YarnCloudAppServiceApplication.resolveApplicationdir(this.springYarnProperties, applicationName)));
        return appId != null ? appId.toString() : null;
    }

    public void killApplication(String applicationId) {
        this.yarnClient.killApplication(ConverterUtils.toApplicationId((String)applicationId));
    }

    public Collection<String> getClustersInfo(ApplicationId applicationId) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(this.restTemplate, (YarnClient)this.yarnClient, applicationId);
        YarnContainerClusterEndpointResource response = operations.getClusters();
        return response.getClusters();
    }

    public List<ContainerClusterReport.ClustersInfoReportData> getClusterInfo(ApplicationId applicationId, String clusterId) {
        ArrayList<ContainerClusterReport.ClustersInfoReportData> data;
        block2: {
            data = new ArrayList<ContainerClusterReport.ClustersInfoReportData>();
            YarnContainerClusterOperations operations = this.buildClusterOperations(this.restTemplate, (YarnClient)this.yarnClient, applicationId);
            try {
                ContainerClusterResource response = operations.clusterInfo(clusterId);
                Integer pany = response.getGridProjection().getProjectionData().getAny();
                Map phosts = response.getGridProjection().getProjectionData().getHosts();
                Map pracks = response.getGridProjection().getProjectionData().getRacks();
                Integer sany = response.getGridProjection().getSatisfyState().getAllocateData().getAny();
                Map shosts = response.getGridProjection().getSatisfyState().getAllocateData().getHosts();
                Map sracks = response.getGridProjection().getSatisfyState().getAllocateData().getRacks();
                data.add(new ContainerClusterReport.ClustersInfoReportData(response.getContainerClusterState().getClusterState().toString(), Integer.valueOf(response.getGridProjection().getMembers().size()), pany, phosts, pracks, sany, shosts, sracks));
            }
            catch (YarnContainerClusterClientException e) {
                HttpStatus statusCode;
                if (!(e.getRootCause() instanceof HttpClientErrorException) || (statusCode = ((HttpClientErrorException)e.getRootCause()).getStatusCode()) == HttpStatus.NOT_FOUND) break block2;
                throw e;
            }
        }
        return data;
    }

    public void createCluster(ApplicationId applicationId, String clusterId, String clusterDef, String projectionType, Integer projectionDataAny, Map<String, Integer> hosts, Map<String, Integer> racks, Map<String, Object> projectionDataProperties, Map<String, Object> extraProperties) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(this.restTemplate, (YarnClient)this.yarnClient, applicationId);
        ContainerClusterCreateRequest request = new ContainerClusterCreateRequest();
        request.setClusterId(clusterId);
        request.setClusterDef(clusterDef);
        request.setProjection(projectionType);
        request.setExtraProperties(extraProperties);
        AbstractContainerClusterRequest.ProjectionDataType projectionData = new AbstractContainerClusterRequest.ProjectionDataType();
        projectionData.setAny(projectionDataAny);
        projectionData.setHosts(hosts);
        projectionData.setRacks(racks);
        projectionData.setProperties(projectionDataProperties);
        request.setProjectionData(projectionData);
        operations.clusterCreate(request);
    }

    public void destroyCluster(ApplicationId applicationId, String clusterId) {
        Collection<YarnCloudAppService.CloudAppInstanceInfo> submittedApplications = this.getSubmittedApplications(applicationId.toString());
        if (submittedApplications.isEmpty()) {
            return;
        }
        if (submittedApplications.iterator().next().getState() != "RUNNING") {
            return;
        }
        YarnContainerClusterOperations operations = this.buildClusterOperations(this.restTemplate, (YarnClient)this.yarnClient, applicationId);
        operations.clusterDestroy(clusterId);
    }

    public void startCluster(ApplicationId applicationId, String clusterId) {
        YarnContainerClusterOperations operations = this.buildClusterOperations(this.restTemplate, (YarnClient)this.yarnClient, applicationId);
        ContainerClusterModifyRequest request = new ContainerClusterModifyRequest();
        request.setAction("start");
        operations.clusterStart(clusterId, request);
    }

    public void stopCluster(ApplicationId applicationId, String clusterId) {
        Collection<YarnCloudAppService.CloudAppInstanceInfo> submittedApplications = this.getSubmittedApplications(applicationId.toString());
        if (submittedApplications.isEmpty()) {
            return;
        }
        if (submittedApplications.iterator().next().getState() != "RUNNING") {
            return;
        }
        YarnContainerClusterOperations operations = this.buildClusterOperations(this.restTemplate, (YarnClient)this.yarnClient, applicationId);
        ContainerClusterModifyRequest request = new ContainerClusterModifyRequest();
        request.setAction("stop");
        operations.clusterStop(clusterId, request);
    }

    private synchronized YarnContainerClusterOperations buildClusterOperations(RestTemplate restTemplate, YarnClient client, ApplicationId applicationId) {
        String key = applicationId.toString();
        YarnContainerClusterOperations operations = this.operationsCache.get(key);
        if (operations == null) {
            ApplicationReport report = client.getApplicationReport(applicationId);
            String trackingUrl = report.getOriginalTrackingUrl();
            operations = new YarnContainerClusterTemplate(trackingUrl + "/" + "yarn_containercluster", restTemplate);
            this.operationsCache.put(key, operations);
        }
        return operations;
    }

    private static String resolveApplicationdir(SpringYarnProperties springYarnProperties, String applicationName) {
        String applicationBaseDir = springYarnProperties.getApplicationBaseDir();
        if (!applicationBaseDir.endsWith("/")) {
            applicationBaseDir = applicationBaseDir + "/";
        }
        return applicationBaseDir + applicationName + "/";
    }

    @org.springframework.context.annotation.Configuration
    @EnableAutoConfiguration(exclude={EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, JmxAutoConfiguration.class, BatchAutoConfiguration.class, JmxAutoConfiguration.class, EndpointMBeanExportAutoConfiguration.class, EndpointAutoConfiguration.class}, excludeName={"org.springframework.cloud.dataflow.server.config.DataFlowControllerAutoConfiguration", "org.springframework.cloud.deployer.spi.yarn.autoconfigure.YarnDeployerAutoConfiguration"})
    public static class Config {
    }
}

