/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.cloud.deployer.spi.yarn.YarnDeployerProperties;
import org.springframework.core.io.Resource;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.yarn.support.console.ContainerClusterReport;

public class YarnAppDeployer
implements AppDeployer {
    private static final Logger logger = LoggerFactory.getLogger(YarnAppDeployer.class);
    private final YarnCloudAppService yarnCloudAppService;
    private final StateMachine<String, String> stateMachine;
    @Autowired
    private YarnDeployerProperties yarnDeployerProperties;

    public YarnAppDeployer(YarnCloudAppService yarnCloudAppService, StateMachine<String, String> stateMachine) {
        this.yarnCloudAppService = yarnCloudAppService;
        this.stateMachine = stateMachine;
    }

    public String deploy(AppDeploymentRequest request) {
        logger.info("Deploy request for {}", (Object)request);
        final AppDefinition definition = request.getDefinition();
        Map definitionParameters = definition.getProperties();
        Map deploymentProperties = request.getDeploymentProperties();
        logger.info("Deploying request for definition {}", (Object)definition);
        logger.info("Parameters for definition {}", (Object)definitionParameters);
        logger.info("Deployment properties for request {}", (Object)deploymentProperties);
        int count = 1;
        String countString = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
        if (StringUtils.hasText((String)countString)) {
            count = Integer.parseInt(countString);
        }
        final String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        Resource resource = request.getResource();
        String clusterId = group + ":" + definition.getName();
        ArrayList<String> contextRunArgs = new ArrayList<String>();
        contextRunArgs.add("--spring.yarn.appName=scdstream:app:" + group);
        for (Map.Entry entry : deploymentProperties.entrySet()) {
            if (((String)entry.getKey()).startsWith("spring.cloud.deployer.yarn.app.streamappmaster")) {
                contextRunArgs.add("--" + (String)entry.getKey() + "=" + (String)entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).startsWith("spring.cloud.deployer.yarn.app.streamcontainer")) continue;
            contextRunArgs.add("--spring.yarn.client.launchcontext.arguments.--" + (String)entry.getKey() + "='" + (String)entry.getValue() + "'");
        }
        String baseDir = this.yarnDeployerProperties.getBaseDir();
        if (!baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        String artifactPath = this.isHdfsResource(resource) ? this.getHdfsArtifactPath(resource) : baseDir + "/artifacts/cache/";
        contextRunArgs.add("--spring.yarn.client.launchcontext.arguments.--spring.cloud.deployer.yarn.appmaster.artifact=" + artifactPath);
        final Message message = MessageBuilder.withPayload((Object)"DEPLOY").setHeader("appVersion", (Object)"app").setHeader("clusterId", (Object)clusterId).setHeader("groupId", (Object)group).setHeader("count", (Object)count).setHeader("artifact", (Object)resource).setHeader("artifactDir", (Object)artifactPath).setHeader("definitionParameters", (Object)definitionParameters).setHeader("contextRunArgs", contextRunArgs).build();
        final SettableListenableFuture id = new SettableListenableFuture();
        StateMachineListenerAdapter<String, String> listener = new StateMachineListenerAdapter<String, String>(){

            public void stateContext(StateContext<String, String> stateContext) {
                if (stateContext.getStage() == StateContext.Stage.STATE_ENTRY && ((String)stateContext.getTarget().getId()).equals("READY") && ObjectUtils.nullSafeEquals((Object)message.getHeaders().getId().toString(), (Object)stateContext.getExtendedState().get((Object)"messageId", String.class))) {
                    Exception exception = (Exception)stateContext.getExtendedState().get((Object)"error", Exception.class);
                    if (exception != null) {
                        id.setException((Throwable)exception);
                    } else {
                        String applicationId = (String)stateContext.getStateMachine().getExtendedState().get((Object)"applicationId", String.class);
                        DeploymentKey key = new DeploymentKey(group, definition.getName(), applicationId);
                        id.set((Object)key.toString());
                    }
                }
            }
        };
        this.stateMachine.addStateListener((StateMachineListener)listener);
        id.addCallback((ListenableFutureCallback)new ListenableFutureCallback<String>((StateMachineListener)listener){
            final /* synthetic */ StateMachineListener val$listener;
            {
                this.val$listener = stateMachineListener;
            }

            public void onSuccess(String result) {
                YarnAppDeployer.this.stateMachine.removeStateListener(this.val$listener);
            }

            public void onFailure(Throwable ex) {
                YarnAppDeployer.this.stateMachine.removeStateListener(this.val$listener);
            }
        });
        this.stateMachine.sendEvent(message);
        try {
            return (String)id.get(2L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void undeploy(String id) {
        logger.info("Undeploy request for id {}", (Object)id);
        DeploymentKey key = new DeploymentKey(id);
        Message message = MessageBuilder.withPayload((Object)"UNDEPLOY").setHeader("clusterId", (Object)key.getClusterId()).setHeader("appVersion", (Object)"app").setHeader("groupId", (Object)key.group).setHeader("applicationId", (Object)key.applicationId).build();
        this.stateMachine.sendEvent(message);
    }

    public AppStatus status(String id) {
        logger.info("Checking status of {}", (Object)id);
        DeploymentKey key = new DeploymentKey(id);
        AppStatus.Builder builder = AppStatus.of((String)id);
        for (Map.Entry<String, ContainerClusterReport.ClustersInfoReportData> entry : this.yarnCloudAppService.getClustersStates(key.applicationId).entrySet()) {
            if (!ObjectUtils.nullSafeEquals((Object)entry.getKey(), (Object)key.getClusterId())) continue;
            ContainerClusterReport.ClustersInfoReportData data = entry.getValue();
            for (int i = 0; i < data.getProjectionAny(); ++i) {
                InstanceStatus instanceStatus = new InstanceStatus(key.getClusterId() + "-" + i, i < data.getCount(), null);
                builder.with((AppInstanceStatus)instanceStatus);
            }
        }
        return builder.build();
    }

    private boolean isHdfsResource(Resource resource) {
        try {
            return resource != null && resource.getURI().getScheme().equals("hdfs");
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getHdfsArtifactPath(Resource resource) {
        String path = null;
        try {
            path = "/" + FilenameUtils.getPath((String)resource.getURI().getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    private static class InstanceStatus
    implements AppInstanceStatus {
        private final String id;
        private final DeploymentState state;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public InstanceStatus(String id, boolean deployed, Map<String, String> attributes) {
            this.id = id;
            DeploymentState deploymentState = this.state = deployed ? DeploymentState.deployed : DeploymentState.unknown;
            if (attributes != null) {
                this.attributes.putAll(attributes);
            }
        }

        public String getId() {
            return this.id;
        }

        public DeploymentState getState() {
            return this.state;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return "InstanceStatus [id=" + this.id + ", state=" + this.state + ", attributes=" + this.attributes + "]";
        }
    }

    private static class DeploymentKey {
        static final String SEPARATOR = ":";
        final String group;
        final String name;
        final String applicationId;
        final String clusterId;

        public DeploymentKey(String id) {
            String[] split = id.split(SEPARATOR);
            Assert.isTrue((split.length == 3 ? 1 : 0) != 0, (String)("Unable to parse deployment key " + id));
            this.group = split[0];
            this.name = split[1];
            this.applicationId = split[2];
            this.clusterId = this.group + SEPARATOR + this.name;
        }

        public DeploymentKey(String group, String name, String applicationId) {
            Assert.notNull((Object)group, (String)"Group must be set");
            Assert.notNull((Object)name, (String)"Name must be set");
            Assert.notNull((Object)applicationId, (String)"Application id must be set");
            this.group = group;
            this.name = name;
            this.applicationId = applicationId;
            this.clusterId = group + SEPARATOR + name;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public String toString() {
            return this.group + SEPARATOR + this.name + SEPARATOR + this.applicationId;
        }
    }
}

