/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppServiceApplication;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.fs.FsShell;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.yarn.support.console.ContainerClusterReport;

public class DefaultYarnCloudAppService
implements YarnCloudAppService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultYarnCloudAppService.class);
    private final ApplicationContextInitializer<?>[] initializers;
    private final String deployerVersion;
    private final Map<String, YarnCloudAppServiceApplication> appCache = new HashMap<String, YarnCloudAppServiceApplication>();
    private Configuration configuration;

    public DefaultYarnCloudAppService(String deployerVersion) {
        this(deployerVersion, null);
    }

    public DefaultYarnCloudAppService(String deployerVersion, ApplicationContextInitializer<?>[] initializers) {
        this.deployerVersion = deployerVersion;
        this.initializers = initializers;
    }

    @Autowired
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushArtifact(Resource artifact, String dir) {
        File tmp = null;
        try {
            tmp = File.createTempFile(UUID.randomUUID().toString(), null);
            tmp.deleteOnExit();
            FileCopyUtils.copy((InputStream)artifact.getInputStream(), (OutputStream)new FileOutputStream(tmp));
            FsShell shell = new FsShell(this.configuration);
            String artifactPath = dir + "/" + artifact.getFile().getName();
            if (!shell.test(artifactPath)) {
                logger.info("Pushing artifact {} into dir {}", (Object)artifact, (Object)dir);
                shell.copyFromLocal(tmp.getAbsolutePath(), artifactPath);
            }
        }
        catch (Exception e) {
            logger.error("Error pushing artifact", (Throwable)e);
        }
        finally {
            if (tmp != null) {
                try {
                    tmp.delete();
                }
                catch (Exception e) {}
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    @Override
    public Collection<YarnCloudAppService.CloudAppInfo> getApplications(YarnCloudAppService.CloudAppType cloudAppType) {
        return this.getApp(null, null, cloudAppType).getPushedApplications();
    }

    @Override
    public Collection<YarnCloudAppService.CloudAppInstanceInfo> getInstances(YarnCloudAppService.CloudAppType cloudAppType) {
        return this.getApp(null, null, cloudAppType).getSubmittedApplications();
    }

    @Override
    public void pushApplication(String appVersion, YarnCloudAppService.CloudAppType cloudAppType) {
        this.getApp(appVersion, this.deployerVersion, cloudAppType, null).pushApplication(appVersion);
    }

    @Override
    public String submitApplication(String appVersion, YarnCloudAppService.CloudAppType cloudAppType) {
        return this.submitApplication(appVersion, cloudAppType, null);
    }

    @Override
    public String submitApplication(String appVersion, YarnCloudAppService.CloudAppType cloudAppType, List<String> contextRunArgs) {
        return this.getApp(appVersion, this.deployerVersion, cloudAppType, contextRunArgs).submitApplication(appVersion);
    }

    @Override
    public void killApplications(String appName, YarnCloudAppService.CloudAppType cloudAppType) {
        YarnCloudAppServiceApplication app = this.getApp(null, null, cloudAppType);
        Collection<YarnCloudAppService.CloudAppInstanceInfo> submittedApplications = app.getSubmittedApplications();
        for (YarnCloudAppService.CloudAppInstanceInfo info : submittedApplications) {
            if (info.getName() != appName) continue;
            app.killApplication(info.getApplicationId());
        }
    }

    @Override
    public void killApplication(String yarnApplicationId, YarnCloudAppService.CloudAppType cloudAppType) {
        YarnCloudAppServiceApplication app = this.getApp(null, null, cloudAppType);
        app.killApplication(yarnApplicationId);
    }

    @Override
    public void createCluster(String yarnApplicationId, String clusterId, int count, String artifact, Map<String, String> definitionParameters) {
        HashMap<String, Object> extraProperties = new HashMap<String, Object>();
        extraProperties.put("containerArtifact", artifact);
        int i = 0;
        for (Map.Entry<String, String> entry : definitionParameters.entrySet()) {
            String value = entry.getValue();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                extraProperties.put("containerArg" + i++, entry.getKey() + "=\\" + value.substring(0, value.length() - 1) + "\\\"");
                continue;
            }
            extraProperties.put("containerArg" + i++, entry.getKey() + "=\\\"" + value + "\\\"");
        }
        this.getApp(null, null, YarnCloudAppService.CloudAppType.STREAM).createCluster(ConverterUtils.toApplicationId((String)yarnApplicationId), clusterId, "module-template", "default", count, null, null, null, extraProperties);
    }

    @Override
    public void startCluster(String yarnApplicationId, String clusterId) {
        this.getApp(null, null, YarnCloudAppService.CloudAppType.STREAM).startCluster(ConverterUtils.toApplicationId((String)yarnApplicationId), clusterId);
    }

    @Override
    public void stopCluster(String yarnApplicationId, String clusterId) {
        this.getApp(null, null, YarnCloudAppService.CloudAppType.STREAM).stopCluster(ConverterUtils.toApplicationId((String)yarnApplicationId), clusterId);
    }

    @Override
    public Map<String, ContainerClusterReport.ClustersInfoReportData> getClustersStates(String yarnApplicationId) {
        HashMap<String, ContainerClusterReport.ClustersInfoReportData> states = new HashMap<String, ContainerClusterReport.ClustersInfoReportData>();
        Collection<YarnCloudAppService.CloudAppInstanceInfo> submittedApplications = this.getApp(null, null, YarnCloudAppService.CloudAppType.STREAM).getSubmittedApplications(yarnApplicationId);
        for (YarnCloudAppService.CloudAppInstanceInfo instanceInfo : submittedApplications) {
            if (!instanceInfo.getName().startsWith("scdstream:app") || !instanceInfo.getState().equals("RUNNING")) continue;
            for (String cluster : this.getClusters(instanceInfo.getApplicationId())) {
                states.putAll(this.getInstanceClustersStates(instanceInfo.getApplicationId(), cluster));
            }
        }
        return states;
    }

    @Override
    public Collection<String> getClusters(String yarnApplicationId) {
        return this.getApp(null, null, YarnCloudAppService.CloudAppType.STREAM).getClustersInfo(ConverterUtils.toApplicationId((String)yarnApplicationId));
    }

    @Override
    public void destroyCluster(String yarnApplicationId, String clusterId) {
        this.getApp(null, null, YarnCloudAppService.CloudAppType.STREAM).destroyCluster(ConverterUtils.toApplicationId((String)yarnApplicationId), clusterId);
    }

    private Map<String, ContainerClusterReport.ClustersInfoReportData> getInstanceClustersStates(String yarnApplicationId, String clusterId) {
        HashMap<String, ContainerClusterReport.ClustersInfoReportData> states = new HashMap<String, ContainerClusterReport.ClustersInfoReportData>();
        List<ContainerClusterReport.ClustersInfoReportData> clusterInfo = this.getApp(null, null, YarnCloudAppService.CloudAppType.STREAM).getClusterInfo(ConverterUtils.toApplicationId((String)yarnApplicationId), clusterId);
        if (clusterInfo.size() == 1) {
            states.put(clusterId, clusterInfo.get(0));
        }
        return states;
    }

    protected List<String> processContextRunArgs(List<String> contextRunArgs) {
        return contextRunArgs;
    }

    private synchronized YarnCloudAppServiceApplication getApp(String appVersion, String dataflowVersion, YarnCloudAppService.CloudAppType cloudAppType) {
        return this.getApp(appVersion, dataflowVersion, cloudAppType, null);
    }

    private synchronized YarnCloudAppServiceApplication getApp(String appVersion, String dataflowVersion, YarnCloudAppService.CloudAppType cloudAppType, List<String> contextRunArgs) {
        contextRunArgs = this.processContextRunArgs(contextRunArgs);
        String cacheKey = (Object)((Object)cloudAppType) + appVersion + StringUtils.collectionToCommaDelimitedString(contextRunArgs);
        YarnCloudAppServiceApplication app = this.appCache.get(cacheKey);
        logger.info("Cachekey {} found YarnCloudAppServiceApplication {}", (Object)cacheKey, (Object)app);
        if (app == null) {
            Properties configFileProperties = new Properties();
            if (StringUtils.hasText((String)appVersion)) {
                configFileProperties.setProperty("spring.yarn.applicationVersion", appVersion);
            }
            if (StringUtils.hasText((String)dataflowVersion)) {
                configFileProperties.setProperty("spring.cloud.deployer.yarn.version", dataflowVersion);
            }
            logger.info("Bootsrapping YarnCloudAppServiceApplication with {}", (Object)cloudAppType.toString().toLowerCase());
            ArrayList<String> runArgs = new ArrayList<String>();
            runArgs.add("--spring.config.name=" + cloudAppType.toString().toLowerCase());
            runArgs.add("--spring.jmx.enabled=false");
            if (!ObjectUtils.isEmpty(contextRunArgs)) {
                runArgs.addAll(contextRunArgs);
            }
            app = new YarnCloudAppServiceApplication(appVersion, dataflowVersion, "application.properties", configFileProperties, runArgs.toArray(new String[0]), this.initializers);
            try {
                app.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing YarnCloudAppServiceApplication", e);
            }
            logger.info("Set cache with key {} and YarnCloudAppServiceApplication {}", (Object)cacheKey, (Object)app);
            this.appCache.put(cacheKey, app);
        }
        return app;
    }
}

