/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn.tasklauncher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.yarn.tasklauncher.TaskAppmaster;
import org.springframework.cloud.deployer.spi.yarn.tasklauncher.TaskAppmasterProperties;
import org.springframework.context.Lifecycle;
import org.springframework.util.Assert;
import org.springframework.yarn.am.ContainerLauncherInterceptor;
import org.springframework.yarn.am.StaticEventingAppmaster;
import org.springframework.yarn.am.container.AbstractLauncher;
import org.springframework.yarn.fs.LocalResourcesFactoryBean;
import org.springframework.yarn.fs.ResourceLocalizer;

public class TaskAppmaster
extends StaticEventingAppmaster {
    private static final Log log = LogFactory.getLog(TaskAppmaster.class);
    @Autowired
    private TaskAppmasterProperties taskAppmasterProperties;
    private ResourceLocalizer artifactResourceLocalizer;
    private boolean finishRequested = false;

    protected void onInit() throws Exception {
        super.onInit();
        Assert.hasText((String)this.taskAppmasterProperties.getArtifact(), (String)"Artifact must be set");
        this.artifactResourceLocalizer = this.buildArtifactResourceLocalizer();
        if (this.getLauncher() instanceof AbstractLauncher) {
            ((AbstractLauncher)this.getLauncher()).addInterceptor((ContainerLauncherInterceptor)new ArtifactResourceContainerLaunchInterceptor(this, null));
        }
    }

    protected void doStop() {
        if (this.getAllocator() instanceof Lifecycle) {
            ((Lifecycle)this.getAllocator()).stop();
        }
        if (!this.finishRequested) {
            super.doStop();
        }
    }

    public List<String> getCommands() {
        ArrayList<String> list = new ArrayList<String>(super.getCommands());
        if (this.taskAppmasterProperties.getParameters() != null) {
            for (Map.Entry entry : this.taskAppmasterProperties.getParameters().entrySet()) {
                list.add(Math.max(list.size() - 2, 0), "--" + (String)entry.getKey() + "='" + (String)entry.getValue() + "'");
            }
        }
        if (this.taskAppmasterProperties.getCommandlineArguments() != null) {
            for (String commandlineArgument : this.taskAppmasterProperties.getCommandlineArguments()) {
                list.add(Math.max(list.size() - 2, 0), "'" + commandlineArgument + "'");
            }
        }
        return list;
    }

    protected boolean shutdownContainers() {
        return true;
    }

    protected void notifyCompleted() {
        this.finishAppmaster();
        this.finishRequested = true;
        super.notifyCompleted();
    }

    private ResourceLocalizer buildArtifactResourceLocalizer() throws Exception {
        String artifact = this.taskAppmasterProperties.getArtifact();
        log.info((Object)("Building localizer for artifact " + artifact));
        LocalResourcesFactoryBean fb = new LocalResourcesFactoryBean();
        fb.setConfiguration(this.getConfiguration());
        LocalResourcesFactoryBean.TransferEntry te = new LocalResourcesFactoryBean.TransferEntry(LocalResourceType.FILE, null, artifact, false);
        ArrayList<LocalResourcesFactoryBean.TransferEntry> hdfsEntries = new ArrayList<LocalResourcesFactoryBean.TransferEntry>();
        hdfsEntries.add(te);
        fb.setHdfsEntries(hdfsEntries);
        fb.setCopyEntries(new ArrayList());
        fb.afterPropertiesSet();
        return fb.getObject();
    }

    static /* synthetic */ ResourceLocalizer access$100(TaskAppmaster x0) {
        return x0.artifactResourceLocalizer;
    }
}

