/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.app;

import java.util.Map;
import org.springframework.util.StringUtils;

public class AppAdmin {
    public static final String ADMIN_USER_KEY = "SPRING_CLOUD_STREAMAPP_SECURITY_ADMIN-USER";
    public static final String ADMIN_PASSWORD_KEY = "SPRING_CLOUD_STREAMAPP_SECURITY_ADMIN-PASSWORD";
    public static final String ADMIN_USER_PROPERTY_KEY = "spring.cloud.streamapp.security.admin-user";
    public static final String ADMIN_PASSWORD_PROPERTY_KEY = "spring.cloud.streamapp.security.admin-password";
    private String user;
    private String password;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasCredentials() {
        return StringUtils.hasText((String)this.user) && StringUtils.hasText((String)this.password);
    }

    public void addCredentialsToAppEnvironment(Map<String, String> environment) {
        if (this.hasCredentials()) {
            environment.put(ADMIN_USER_KEY, this.user);
            environment.put(ADMIN_PASSWORD_KEY, this.password);
        }
    }

    public void addCredentialsToAppEnvironmentAsProperties(Map<String, String> environment) {
        if (this.hasCredentials()) {
            environment.put(ADMIN_USER_PROPERTY_KEY, this.user);
            environment.put(ADMIN_PASSWORD_PROPERTY_KEY, this.password);
        }
    }
}

