/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.util;

import org.springframework.util.StringUtils;

public class RuntimeVersionUtils {
    public static String getSpringBootVersion() {
        Class<?> springApp;
        try {
            springApp = Class.forName("org.springframework.boot.SpringApplication");
        }
        catch (ClassNotFoundException e) {
            return "unknown";
        }
        return RuntimeVersionUtils.getVersion(springApp);
    }

    public static String getVersion(Class<?> source) {
        if (source == null) {
            return "null";
        }
        Package sourcePackage = source.getPackage();
        if (sourcePackage == null) {
            return "unknown";
        }
        String version = source.getPackage().getImplementationVersion();
        if (!StringUtils.hasText((String)version)) {
            return "unknown";
        }
        return version;
    }
}

