/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.cloud.deployer.resource.support;

/**
 * Thrown to indicate failure resolving a {@link org.springframework.core.io.Resource}.
 *
 * @author Mark Pollack
 */
@SuppressWarnings("serial")
public class ResourceNotResolvedException extends RuntimeException {

	/**
	 * Create a new {@link ResourceNotResolvedException} with the specified options.
	 * @param message the exception message to display to the user
	 * @param cause the underlying cause
	 */
	public ResourceNotResolvedException(String message, Throwable cause) {
		super(message, cause);
	}
}
