/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.support;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.deployer.resource.support.DownloadingUrlResourceLoader;
import org.springframework.cloud.deployer.resource.support.ResourceNotResolvedException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class DelegatingResourceLoader
implements ResourceLoader,
ResourceLoaderAware {
    private final ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private final Map<String, ResourceLoader> loaders;
    private ResourceLoader defaultResourceLoader = new DefaultResourceLoader();

    public DelegatingResourceLoader() {
        this(null);
    }

    public DelegatingResourceLoader(Map<String, ResourceLoader> loaders) {
        this.loaders = CollectionUtils.isEmpty(loaders) ? Collections.emptyMap() : Collections.unmodifiableMap(loaders);
    }

    public void setResourceLoader(ResourceLoader contextResourceLoader) {
        if (contextResourceLoader != null && contextResourceLoader != this) {
            this.defaultResourceLoader = contextResourceLoader;
        }
    }

    public Resource getResource(String location) {
        try {
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            Assert.notNull((Object)scheme, (String)"a scheme (prefix) is required");
            Object loader = this.loaders.get(scheme);
            if (loader == null) {
                loader = scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https") ? new DownloadingUrlResourceLoader() : this.defaultResourceLoader;
            }
            return loader.getResource(location);
        }
        catch (Exception e) {
            throw new ResourceNotResolvedException(e.getMessage(), e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map<String, ResourceLoader> getLoaders() {
        return this.loaders;
    }
}

