/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.support.ShaUtils;
import org.springframework.core.io.UrlResource;
import org.springframework.util.FileCopyUtils;

public class DownloadingUrlResource
extends UrlResource {
    private static final Logger logger = LoggerFactory.getLogger(DownloadingUrlResource.class);
    private File file;

    public DownloadingUrlResource(String uri) throws MalformedURLException {
        super(uri);
    }

    public synchronized File getFile() throws IOException {
        if (this.file == null) {
            String simpleName = null;
            try {
                Path path = Paths.get(this.getURL().toURI().getPath(), new String[0]);
                simpleName = path.getFileName().toString().replaceAll("[^\\p{IsAlphabetic}^\\p{IsDigit}]", "");
            }
            catch (URISyntaxException e) {
                logger.info("Could not create simple name from last part of URL", (Object)e.getMessage());
            }
            String fileName = ShaUtils.sha1(this.getURL().toString());
            if (simpleName != null) {
                try {
                    this.file = new File(Files.createTempDirectory("spring-cloud-deployer", new FileAttribute[0]).toFile(), fileName + "-" + simpleName);
                }
                catch (IOException e) {
                    logger.info("Could not create simple temp file name using last part of URL");
                }
            }
            if (this.file == null) {
                this.file = new File(Files.createTempDirectory("spring-cloud-deployer", new FileAttribute[0]).toFile(), fileName);
            }
            logger.info("Downloading [" + this.getURL().toString() + "] to " + this.file.getAbsolutePath());
            FileCopyUtils.copy((InputStream)this.getInputStream(), (OutputStream)new FileOutputStream(this.file));
        }
        return this.file;
    }

    public synchronized String getDescription() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("URL [" + this.getURL() + "]");
        }
        catch (IOException e) {
            sb.append("URL [could not be retrieved]");
        }
        if (this.file != null) {
            sb.append(", file [" + this.file.getAbsolutePath() + "]");
        }
        return sb.toString();
    }
}

