/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.support.ShaUtils;
import org.springframework.core.io.UrlResource;
import org.springframework.util.FileCopyUtils;

public class DownloadingUrlResource
extends UrlResource {
    private static final Logger logger = LoggerFactory.getLogger(DownloadingUrlResource.class);
    private File file;

    public DownloadingUrlResource(String uri) throws MalformedURLException {
        super(uri);
    }

    public synchronized File getFile() throws IOException {
        if (this.file == null) {
            String fileName = ShaUtils.sha1(this.getURL().toString());
            this.file = new File(Files.createTempDirectory("spring-cloud-deployer", new FileAttribute[0]).toFile(), fileName);
            logger.info("Downloading [" + this.getURL().toString() + "] to " + this.file.getAbsolutePath());
            FileCopyUtils.copy((InputStream)this.getInputStream(), (OutputStream)new FileOutputStream(this.file));
        }
        return this.file;
    }

    public synchronized String getDescription() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("URL [" + this.getURL() + "]");
        }
        catch (IOException e) {
            sb.append("URL [could not be retrieved]");
        }
        if (this.file != null) {
            sb.append(", file [" + this.file.getAbsolutePath() + "]");
        }
        return sb.toString();
    }
}

