/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.registry;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.deployer.resource.registry.UriRegistry;
import org.springframework.util.Assert;

public class InMemoryUriRegistry
implements UriRegistry {
    private final Map<String, URI> map = new ConcurrentHashMap<String, URI>();

    @Override
    public URI find(String key) {
        Assert.hasLength((String)key, (String)"key required");
        URI uri = this.map.get(key);
        if (uri == null) {
            throw new IllegalArgumentException("No URI found for " + key);
        }
        return uri;
    }

    @Override
    public Map<String, URI> findAll() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void register(String key, URI uri) {
        this.map.put(key, uri);
    }

    @Override
    public void unregister(String key) {
        this.map.remove(key);
    }
}

