/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.support;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class ShaUtils {
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    protected static String sha1(String data) {
        try {
            return new String(ShaUtils.encodeHex(MessageDigest.getInstance("SHA-1").digest(data.getBytes("UTF-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static char[] encodeHex(byte[] data) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = CHARS[(0xF0 & data[i]) >>> 4];
            out[j++] = CHARS[0xF & data[i]];
        }
        return out;
    }
}

