/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.support.ShaUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;

public class DelegatingResourceLoader
implements ResourceLoader,
ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingResourceLoader.class);
    private final ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private final Map<String, ResourceLoader> loaders;
    private ResourceLoader defaultResourceLoader = new DefaultResourceLoader();
    private final File cacheDirectory;
    private static final String DEFAULT_CACHE_PREFIX = "deployer-resource-cache";

    public DelegatingResourceLoader(Map<String, ResourceLoader> loaders) {
        this(loaders, null);
    }

    public DelegatingResourceLoader(Map<String, ResourceLoader> loaders, File cacheDirectory) {
        Assert.notEmpty(loaders, (String)"at least one ResourceLoader is required");
        this.loaders = Collections.unmodifiableMap(loaders);
        this.cacheDirectory = this.initCacheDirectory(cacheDirectory);
    }

    public void setResourceLoader(ResourceLoader contextResourceLoader) {
        if (contextResourceLoader != null && contextResourceLoader != this) {
            this.defaultResourceLoader = contextResourceLoader;
        }
    }

    public Resource getResource(String location) {
        try {
            Resource resource;
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            Assert.notNull((Object)scheme, (String)"a scheme (prefix) is required");
            ResourceLoader loader = this.loaders.get(scheme);
            if (loader == null) {
                loader = this.defaultResourceLoader;
            }
            if (DelegatingResourceLoader.existsAsFile(resource = loader.getResource(location))) {
                return resource;
            }
            String cacheName = scheme + "-" + ShaUtils.sha1(location) + "-" + resource.getFilename();
            File cachedResource = new File(this.cacheDirectory, cacheName);
            if (!cachedResource.exists()) {
                logger.info("Caching file {} as given location {}", (Object)cachedResource, (Object)location);
                try {
                    FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(cachedResource));
                }
                catch (UnsupportedOperationException e) {
                    logger.warn(String.format("Unable to cache file since getInputStream() is not supported for resource: %s", resource));
                    return resource;
                }
            } else {
                logger.info("Reusing cached file {} as given location {}", (Object)cachedResource, (Object)location);
            }
            return new FileSystemResource(cachedResource);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private File initCacheDirectory(File cacheDirectory) {
        try {
            if (cacheDirectory == null) {
                Path tempDirectory = Files.createTempDirectory(DEFAULT_CACHE_PREFIX, new FileAttribute[0]);
                return tempDirectory.toFile();
            }
            cacheDirectory.mkdirs();
            return cacheDirectory;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to create cache directory", e);
        }
    }

    private static boolean existsAsFile(Resource resource) {
        try {
            resource.getFile();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

