/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.maven;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.shared.http.HttpConfiguration;
import org.apache.maven.wagon.shared.http.HttpMethodConfiguration;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;

public class StaticWagonConfigurator
implements WagonConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(StaticWagonConfigurator.class);

    public void configure(Wagon wagon, Object configuration) throws Exception {
        logger.debug("Configuring wagon {} with {}", (Object)wagon, configuration);
        if (wagon instanceof HttpWagon && configuration instanceof MavenProperties.Wagon) {
            HttpWagon httpWagon = (HttpWagon)wagon;
            Map<MavenProperties.WagonHttpMethod, MavenProperties.WagonHttpMethodProperties> httpMethodProperties = ((MavenProperties.Wagon)configuration).getHttp();
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            for (Map.Entry<MavenProperties.WagonHttpMethod, MavenProperties.WagonHttpMethodProperties> entry : httpMethodProperties.entrySet()) {
                switch (entry.getKey()) {
                    case all: {
                        httpConfiguration.setAll(StaticWagonConfigurator.buildConfig(entry.getValue()));
                        break;
                    }
                    case get: {
                        httpConfiguration.setGet(StaticWagonConfigurator.buildConfig(entry.getValue()));
                        break;
                    }
                    case head: {
                        httpConfiguration.setHead(StaticWagonConfigurator.buildConfig(entry.getValue()));
                        break;
                    }
                    case put: {
                        httpConfiguration.setPut(StaticWagonConfigurator.buildConfig(entry.getValue()));
                        break;
                    }
                }
            }
            httpWagon.setHttpConfiguration(httpConfiguration);
        }
    }

    private static HttpMethodConfiguration buildConfig(MavenProperties.WagonHttpMethodProperties properties) {
        HttpMethodConfiguration config = new HttpMethodConfiguration();
        config.setUsePreemptive(properties.isUsePreemptive());
        config.setUseDefaultHeaders(properties.isUseDefaultHeaders());
        if (properties.getConnectionTimeout() != null) {
            config.setConnectionTimeout(properties.getConnectionTimeout().intValue());
        }
        if (properties.getReadTimeout() != null) {
            config.setReadTimeout(properties.getReadTimeout().intValue());
        }
        Properties params = new Properties();
        params.putAll(properties.getParams());
        config.setParams(params);
        Properties headers = new Properties();
        headers.putAll(properties.getHeaders());
        config.setHeaders(headers);
        return config;
    }
}

