/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.mesos.marathon;

import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.MarathonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployer;
import org.springframework.cloud.deployer.spi.mesos.marathon.MarathonAppDeployerProperties;
import org.springframework.cloud.deployer.spi.mesos.marathon.MesosTaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MarathonAppDeployerProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class MarathonAutoConfiguration {
    @Autowired
    private MarathonAppDeployerProperties properties;

    @Bean
    public Marathon marathon() {
        Marathon marathon = MarathonClient.getInstance((String)this.properties.getApiEndpoint());
        return marathon;
    }

    @Bean
    public AppDeployer appDeployer(Marathon marathon) {
        return new MarathonAppDeployer(this.properties, marathon);
    }

    @Bean
    public TaskLauncher taskDeployer(Marathon marathon) {
        return new MesosTaskLauncher();
    }
}

