/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class HttpProbeExecutor {
    private static final Logger logger = LoggerFactory.getLogger(HttpProbeExecutor.class);
    private final RestTemplate restTemplate;
    private final URI uri;

    public HttpProbeExecutor(RestTemplate restTemplate, URI uri) {
        this.restTemplate = restTemplate;
        this.uri = uri;
    }

    public static HttpProbeExecutor from(URL baseUrl, LocalDeployerProperties.HttpProbe httpProbe) {
        URI base = null;
        try {
            base = baseUrl.toURI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (httpProbe == null || httpProbe.getPath() == null || base == null) {
            return null;
        }
        DefaultUriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory(base.toString());
        uriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        URI uri = uriBuilderFactory.builder().path("{path}").build(new Object[]{httpProbe.getPath()});
        return new HttpProbeExecutor(new RestTemplate(), uri);
    }

    public boolean probe() {
        try {
            logger.info("Probing for {}", (Object)this.uri);
            ResponseEntity response = this.restTemplate.getForEntity(this.uri, Void.class);
            HttpStatus statusCode = response.getStatusCode();
            boolean ok = statusCode.is2xxSuccessful();
            if (!ok) {
                logger.info("Probe for {} returned {}", (Object)this.uri, (Object)statusCode);
            }
            return ok;
        }
        catch (Exception e) {
            logger.trace("Probe error for {}", (Object)this.uri, (Object)e);
            return false;
        }
    }
}

