/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ServerSocketFactory;
import org.springframework.util.Assert;

@Deprecated
public class DeployerSocketUtils {
    static final int PORT_RANGE_MAX = 65535;
    private static final Random random = new Random(System.nanoTime());

    public static int findAvailableTcpPort(int minPort) {
        return DeployerSocketUtils.findAvailableTcpPort(minPort, 65535);
    }

    public static int findAvailableTcpPort(int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePort(minPort, maxPort);
    }

    public static SortedSet<Integer> findAvailableTcpPorts(int numRequested, int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePorts(numRequested, minPort, maxPort);
    }

    private static enum SocketType {
        TCP{

            @Override
            protected boolean isPortAvailable(int port) {
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
                    serverSocket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };


        protected abstract boolean isPortAvailable(int var1);

        private int findRandomPort(int minPort, int maxPort) {
            int portRange = maxPort - minPort;
            return minPort + random.nextInt(portRange + 1);
        }

        int findAvailablePort(int minPort, int maxPort) {
            int candidatePort;
            Assert.isTrue((minPort > 0 ? 1 : 0) != 0, (String)"'minPort' must be greater than 0");
            Assert.isTrue((maxPort >= minPort ? 1 : 0) != 0, (String)"'maxPort' must be greater than or equal to 'minPort'");
            Assert.isTrue((maxPort <= 65535 ? 1 : 0) != 0, (String)"'maxPort' must be less than or equal to 65535");
            int portRange = maxPort - minPort;
            int searchCounter = 0;
            do {
                if (searchCounter > portRange) {
                    throw new IllegalStateException(String.format("Could not find an available %s port in the range [%d, %d] after %d attempts", this.name(), minPort, maxPort, searchCounter));
                }
                candidatePort = this.findRandomPort(minPort, maxPort);
                ++searchCounter;
            } while (!this.isPortAvailable(candidatePort));
            return candidatePort;
        }

        SortedSet<Integer> findAvailablePorts(int numRequested, int minPort, int maxPort) {
            Assert.isTrue((minPort > 0 ? 1 : 0) != 0, (String)"'minPort' must be greater than 0");
            Assert.isTrue((maxPort > minPort ? 1 : 0) != 0, (String)"'maxPort' must be greater than 'minPort'");
            Assert.isTrue((maxPort <= 65535 ? 1 : 0) != 0, (String)"'maxPort' must be less than or equal to 65535");
            Assert.isTrue((numRequested > 0 ? 1 : 0) != 0, (String)"'numRequested' must be greater than 0");
            Assert.isTrue((maxPort - minPort >= numRequested ? 1 : 0) != 0, (String)"'numRequested' must not be greater than 'maxPort' - 'minPort'");
            TreeSet<Integer> availablePorts = new TreeSet<Integer>();
            int attemptCount = 0;
            while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
                availablePorts.add(this.findAvailablePort(minPort, maxPort));
            }
            if (availablePorts.size() != numRequested) {
                throw new IllegalStateException(String.format("Could not find %d available %s ports in the range [%d, %d]", numRequested, this.name(), minPort, maxPort));
            }
            return availablePorts;
        }
    }
}

