/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.AbstractLocalDeployerSupport;
import org.springframework.cloud.deployer.spi.local.CommandBuilder;
import org.springframework.cloud.deployer.spi.local.DebugAddress;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.util.StringUtils;

public class DockerCommandBuilder
implements CommandBuilder {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String DOCKER_CONTAINER_NAME_KEY = "spring.cloud.deployer.docker.container.name";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String dockerNetwork;

    public DockerCommandBuilder(String dockerNetwork) {
        this.dockerNetwork = dockerNetwork;
    }

    @Override
    public int getPortSuggestion(LocalDeployerProperties localDeployerProperties) {
        return ThreadLocalRandom.current().nextInt(localDeployerProperties.getDocker().getPortRange().getLow(), localDeployerProperties.getDocker().getPortRange().getHigh());
    }

    @Override
    public URL getBaseUrl(String deploymentId, int index, int port) {
        try {
            return new URL("http", String.format("%s-%d", deploymentId, index), port, "");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ProcessBuilder buildExecutionCommand(AppDeploymentRequest request, Map<String, String> appInstanceEnv, String deployerId, Optional<Integer> appInstanceNumber, LocalDeployerProperties localDeployerProperties, Optional<DebugAddress> debugAddressOption) {
        appInstanceEnv.put("deployerId", deployerId);
        List<String> commands = this.addDockerOptions(request, appInstanceEnv, appInstanceNumber, localDeployerProperties, debugAddressOption);
        commands.addAll(request.getCommandlineArguments());
        this.logger.debug("Docker Command = " + commands);
        return new ProcessBuilder(Arrays.asList(AbstractLocalDeployerSupport.windowsSupport(commands.toArray(new String[0]))));
    }

    private List<String> addDockerOptions(AppDeploymentRequest request, Map<String, String> appInstanceEnv, Optional<Integer> appInstanceNumber, LocalDeployerProperties localDeployerProperties, Optional<DebugAddress> debugAddressOption) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("docker");
        commands.add("run");
        if (StringUtils.hasText((String)this.dockerNetwork)) {
            commands.add("--network");
            commands.add(this.dockerNetwork);
        }
        if (localDeployerProperties.getDocker().isDeleteContainerOnExit()) {
            commands.add("--rm");
        }
        for (String env : appInstanceEnv.keySet()) {
            commands.add("-e");
            commands.add(String.format("%s=%s", env, appInstanceEnv.get(env)));
        }
        debugAddressOption.ifPresent(debugAddress -> {
            String debugCommand = this.getJdwpOptions(debugAddress.getSuspend(), debugAddress.getAddress());
            this.logger.debug("Deploying app with Debug Command = [{}]", (Object)debugCommand);
            commands.add("-e");
            commands.add("JAVA_TOOL_OPTIONS=" + debugCommand);
            commands.add("-p");
            commands.add(String.format("%s:%s", debugAddress.getPort(), debugAddress.getPort()));
        });
        String port = this.getPort(appInstanceEnv);
        if (StringUtils.hasText((String)port)) {
            commands.add("-p");
            commands.add(String.format("%s:%s", port, port));
        }
        if (request.getDeploymentProperties().containsKey(DOCKER_CONTAINER_NAME_KEY)) {
            if (appInstanceNumber.isPresent()) {
                commands.add(String.format("--name=%s-%d", request.getDeploymentProperties().get(DOCKER_CONTAINER_NAME_KEY), appInstanceNumber.get()));
            } else {
                commands.add(String.format("--name=%s", request.getDeploymentProperties().get(DOCKER_CONTAINER_NAME_KEY)));
            }
        } else {
            String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
            if (StringUtils.hasText((String)group)) {
                String deploymentId = String.format("%s.%s", group, request.getDefinition().getName());
                int index = appInstanceNumber.orElse(0);
                commands.add(String.format("--name=%s-%d", deploymentId, index));
            }
        }
        DockerResource dockerResource = (DockerResource)request.getResource();
        try {
            String dockerImageURI = dockerResource.getURI().toString();
            commands.add(dockerImageURI.substring("docker:".length()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return commands;
    }

    private String getPort(Map<String, String> appInstanceEnv) {
        if (appInstanceEnv.containsKey("SPRING_APPLICATION_JSON")) {
            try {
                HashMap flatProperties = new HashMap((Map)OBJECT_MAPPER.readValue(appInstanceEnv.get("SPRING_APPLICATION_JSON"), (TypeReference)new TypeReference<HashMap<String, String>>(){}));
                if (flatProperties.containsKey("server.port")) {
                    return (String)flatProperties.get("server.port");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to determine server port from SPRING_APPLICATION_JSON");
            }
        }
        return appInstanceEnv.get("server.port");
    }
}

