/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.AbstractLocalDeployerSupport;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.util.SocketUtils;

public class LocalTaskLauncher
extends AbstractLocalDeployerSupport
implements TaskLauncher {
    private Path logPathRoot;
    private static final Logger logger = LoggerFactory.getLogger(LocalTaskLauncher.class);
    private static final String SERVER_PORT_KEY = "server.port";
    private static final String JMX_DEFAULT_DOMAIN_KEY = "spring.jmx.default-domain";
    private static final int DEFAULT_SERVER_PORT = 8080;
    private final Map<String, TaskInstance> running = new ConcurrentHashMap<String, TaskInstance>();

    public LocalTaskLauncher(LocalDeployerProperties properties) {
        super(properties);
    }

    public String launch(AppDeploymentRequest request) {
        if (this.logPathRoot == null) {
            try {
                this.logPathRoot = Files.createTempDirectory(this.getLocalDeployerProperties().getWorkingDirectoriesRoot(), "spring-cloud-dataflow-", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        String taskLaunchId = request.getDefinition().getName();
        boolean useDynamicPort = !request.getDefinition().getProperties().containsKey(SERVER_PORT_KEY);
        HashMap<String, String> args = new HashMap<String, String>();
        args.putAll(request.getDefinition().getProperties());
        args.put(JMX_DEFAULT_DOMAIN_KEY, taskLaunchId);
        args.put("endpoints.shutdown.enabled", "true");
        args.put("endpoints.jmx.unique-names", "true");
        try {
            int port;
            String qualifiedName = request.getDefinition().getName() + "-" + System.currentTimeMillis();
            Path dir = Paths.get(this.logPathRoot.toFile().getAbsolutePath(), qualifiedName);
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
                dir.toFile().deleteOnExit();
            }
            Path workDir = Files.createDirectory(Paths.get(dir.toFile().getAbsolutePath(), taskLaunchId), new FileAttribute[0]);
            if (this.getLocalDeployerProperties().isDeleteFilesOnExit()) {
                workDir.toFile().deleteOnExit();
            }
            int n = port = useDynamicPort ? SocketUtils.findAvailableTcpPort((int)8080) : Integer.parseInt((String)request.getDefinition().getProperties().get(SERVER_PORT_KEY));
            if (useDynamicPort) {
                args.put(SERVER_PORT_KEY, String.valueOf(port));
            }
            ProcessBuilder builder = this.buildProcessBuilder(request, args);
            TaskInstance instance = new TaskInstance(builder, workDir, port);
            this.running.put(taskLaunchId, instance);
            if (this.getLocalDeployerProperties().isDeleteFilesOnExit()) {
                instance.stdout.deleteOnExit();
                instance.stderr.deleteOnExit();
            }
            logger.info("launching task {}\n   Logs will be in {}", (Object)taskLaunchId, (Object)workDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception trying to launch " + request, e);
        }
        return taskLaunchId;
    }

    public void cancel(String id) {
        AbstractLocalDeployerSupport.Instance instance = this.running.get(id);
        if (instance != null) {
            if (LocalTaskLauncher.isAlive(instance.getProcess())) {
                this.shutdownAndWait(instance);
            }
            this.running.remove(id);
        }
    }

    public TaskStatus status(String id) {
        TaskInstance instance = this.running.get(id);
        if (instance != null) {
            return new TaskStatus(id, instance.getState(), instance.getAttributes());
        }
        return new TaskStatus(id, LaunchState.unknown, null);
    }

    @PreDestroy
    public void shutdown() throws Exception {
        for (String taskLaunchId : this.running.keySet()) {
            this.cancel(taskLaunchId);
        }
    }

    private static Integer getProcessExitValue(Process process) {
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    private static class TaskInstance
    implements AbstractLocalDeployerSupport.Instance {
        private final Process process;
        private final File workDir;
        private final File stdout;
        private final File stderr;
        private final URL baseUrl;

        private TaskInstance(ProcessBuilder builder, Path workDir, int port) throws IOException {
            builder.directory(workDir.toFile());
            String workDirPath = workDir.toFile().getAbsolutePath();
            this.stdout = Files.createFile(Paths.get(workDirPath, "stdout.log"), new FileAttribute[0]).toFile();
            this.stderr = Files.createFile(Paths.get(workDirPath, "stderr.log"), new FileAttribute[0]).toFile();
            builder.redirectOutput(this.stdout);
            builder.redirectError(this.stderr);
            this.process = builder.start();
            this.workDir = workDir.toFile();
            this.baseUrl = new URL("http", Inet4Address.getLocalHost().getHostAddress(), port, "");
        }

        @Override
        public URL getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public Process getProcess() {
            return this.process;
        }

        public LaunchState getState() {
            Integer exit = LocalTaskLauncher.getProcessExitValue(this.process);
            if (exit != null) {
                if (exit == 0) {
                    return LaunchState.complete;
                }
                return LaunchState.failed;
            }
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)this.baseUrl.openConnection();
                urlConnection.connect();
                urlConnection.disconnect();
                return LaunchState.running;
            }
            catch (IOException e) {
                return LaunchState.launching;
            }
        }

        private Map<String, String> getAttributes() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("working.dir", this.workDir.getAbsolutePath());
            result.put("stdout", this.stdout.getAbsolutePath());
            result.put("stderr", this.stderr.getAbsolutePath());
            result.put("url", this.baseUrl.toString());
            return result;
        }
    }
}

