/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.AbstractLocalDeployerSupport;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

public class LocalAppDeployer
extends AbstractLocalDeployerSupport
implements AppDeployer {
    private Path logPathRoot;
    private static final Logger logger = LoggerFactory.getLogger(LocalAppDeployer.class);
    private static final String SERVER_PORT_KEY = "server.port";
    private static final String JMX_DEFAULT_DOMAIN_KEY = "spring.jmx.default-domain";
    private static final int DEFAULT_SERVER_PORT = 8080;
    private final Map<String, List<AppInstance>> running = new ConcurrentHashMap<String, List<AppInstance>>();

    public LocalAppDeployer(LocalDeployerProperties properties) {
        super(properties);
        try {
            this.logPathRoot = Files.createTempDirectory(properties.getWorkingDirectoriesRoot(), "spring-cloud-dataflow-", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create workdir root: " + properties.getWorkingDirectoriesRoot(), e);
        }
    }

    public String deploy(AppDeploymentRequest request) {
        String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = String.format("%s.%s", group, request.getDefinition().getName());
        DeploymentState state = this.status(deploymentId).getState();
        if (state != DeploymentState.unknown) {
            throw new IllegalStateException(String.format("App %s is already deployed with state %s", deploymentId, state));
        }
        ArrayList<AppInstance> processes = new ArrayList<AppInstance>();
        this.running.put(deploymentId, processes);
        boolean useDynamicPort = !request.getDefinition().getProperties().containsKey(SERVER_PORT_KEY);
        HashMap<String, String> args = new HashMap<String, String>();
        args.putAll(request.getDefinition().getProperties());
        args.put(JMX_DEFAULT_DOMAIN_KEY, deploymentId);
        args.put("endpoints.shutdown.enabled", "true");
        args.put("endpoints.jmx.unique-names", "true");
        try {
            String countProperty;
            Path deploymentGroupDir = Paths.get(this.logPathRoot.toFile().getAbsolutePath(), group + "-" + System.currentTimeMillis());
            if (!Files.exists(deploymentGroupDir, new LinkOption[0])) {
                Files.createDirectory(deploymentGroupDir, new FileAttribute[0]);
                deploymentGroupDir.toFile().deleteOnExit();
            }
            Path workDir = Files.createDirectory(Paths.get(deploymentGroupDir.toFile().getAbsolutePath(), deploymentId), new FileAttribute[0]);
            if (this.getLocalDeployerProperties().isDeleteFilesOnExit()) {
                workDir.toFile().deleteOnExit();
            }
            int count = StringUtils.hasText((String)(countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count"))) ? Integer.parseInt(countProperty) : 1;
            for (int i = 0; i < count; ++i) {
                int port;
                int n = port = useDynamicPort ? SocketUtils.findAvailableTcpPort((int)8080) : Integer.parseInt((String)request.getDefinition().getProperties().get(SERVER_PORT_KEY));
                if (useDynamicPort) {
                    args.put(SERVER_PORT_KEY, String.valueOf(port));
                }
                ProcessBuilder builder = this.buildProcessBuilder(request, args);
                AppInstance instance = new AppInstance(deploymentId, i, builder, workDir, port);
                processes.add(instance);
                if (this.getLocalDeployerProperties().isDeleteFilesOnExit()) {
                    instance.stdout.deleteOnExit();
                    instance.stderr.deleteOnExit();
                }
                logger.info("deploying app {} instance {}\n   Logs will be in {}", new Object[]{deploymentId, i, workDir});
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception trying to deploy " + request, e);
        }
        return deploymentId;
    }

    public void undeploy(String id) {
        List<AppInstance> processes = this.running.get(id);
        if (processes != null) {
            for (AppInstance instance : processes) {
                if (!LocalAppDeployer.isAlive(instance.getProcess())) continue;
                logger.info("un-deploying app {} instance {}", (Object)id, (Object)instance.getInstanceNumber());
                this.shutdownAndWait(instance);
            }
            this.running.remove(id);
        }
    }

    public AppStatus status(String id) {
        AppStatus status;
        List<AppInstance> instances = this.running.get(id);
        AppStatus.Builder builder = AppStatus.of((String)id);
        if (instances != null) {
            for (AppInstance instance : instances) {
                builder.with((AppInstanceStatus)instance);
            }
        }
        if (DeploymentState.undeployed.equals((Object)(status = builder.build()).getState())) {
            this.undeploy(id);
        }
        return status;
    }

    @PreDestroy
    public void shutdown() throws Exception {
        for (String deploymentId : this.running.keySet()) {
            this.undeploy(deploymentId);
        }
    }

    private static Integer getProcessExitValue(Process process) {
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    private static class AppInstance
    implements AbstractLocalDeployerSupport.Instance,
    AppInstanceStatus {
        private final String deploymentId;
        private final int instanceNumber;
        private final Process process;
        private final File workDir;
        private final File stdout;
        private final File stderr;
        private final URL baseUrl;

        private AppInstance(String deploymentId, int instanceNumber, ProcessBuilder builder, Path workDir, int port) throws IOException {
            this.deploymentId = deploymentId;
            this.instanceNumber = instanceNumber;
            builder.directory(workDir.toFile());
            String workDirPath = workDir.toFile().getAbsolutePath();
            this.stdout = Files.createFile(Paths.get(workDirPath, "stdout_" + instanceNumber + ".log"), new FileAttribute[0]).toFile();
            this.stderr = Files.createFile(Paths.get(workDirPath, "stderr_" + instanceNumber + ".log"), new FileAttribute[0]).toFile();
            builder.redirectOutput(this.stdout);
            builder.redirectError(this.stderr);
            builder.environment().put("INSTANCE_INDEX", Integer.toString(instanceNumber));
            this.process = builder.start();
            this.workDir = workDir.toFile();
            this.baseUrl = new URL("http", Inet4Address.getLocalHost().getHostAddress(), port, "");
        }

        public String getId() {
            return this.deploymentId + "-" + this.instanceNumber;
        }

        @Override
        public URL getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public Process getProcess() {
            return this.process;
        }

        public String toString() {
            return String.format("%s [%s]", this.getId(), this.getState());
        }

        public DeploymentState getState() {
            Integer exit = LocalAppDeployer.getProcessExitValue(this.process);
            if (exit != null) {
                if (exit == 0) {
                    return DeploymentState.undeployed;
                }
                return DeploymentState.failed;
            }
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)this.baseUrl.openConnection();
                urlConnection.setConnectTimeout(100);
                urlConnection.connect();
                urlConnection.disconnect();
                return DeploymentState.deployed;
            }
            catch (IOException e) {
                return DeploymentState.deploying;
            }
        }

        public int getInstanceNumber() {
            return this.instanceNumber;
        }

        public Map<String, String> getAttributes() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("working.dir", this.workDir.getAbsolutePath());
            result.put("stdout", this.stdout.getAbsolutePath());
            result.put("stderr", this.stderr.getAbsolutePath());
            result.put("url", this.baseUrl.toString());
            return result;
        }
    }
}

