/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.HandlerBuilder;
import io.fabric8.kubernetes.api.model.HandlerFluent;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DeploymentPropertiesResolver;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppInstanceStatus;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.support.PropertyParserUtils;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.util.StringUtils;

public class AbstractKubernetesDeployer {
    protected static final String SPRING_DEPLOYMENT_KEY = "spring-deployment-id";
    protected static final String SPRING_GROUP_KEY = "spring-group-id";
    protected static final String SPRING_APP_KEY = "spring-app-id";
    protected static final String SPRING_MARKER_KEY = "role";
    protected static final String SPRING_MARKER_VALUE = "spring-app";
    protected static final String APP_NAME_PROPERTY_KEY = "spring.cloud.deployer.appName";
    protected static final String APP_NAME_KEY = "spring-application-name";
    private static final String SERVER_PORT_KEY = "server.port";
    protected final Log logger = LogFactory.getLog((String)this.getClass().getName());
    protected ContainerFactory containerFactory;
    protected KubernetesClient client;
    protected KubernetesDeployerProperties properties;
    protected DeploymentPropertiesResolver deploymentPropertiesResolver;

    protected RuntimeEnvironmentInfo createRuntimeEnvironmentInfo(Class spiClass, Class implementationClass) {
        return new RuntimeEnvironmentInfo.Builder().spiClass(spiClass).implementationName(implementationClass.getSimpleName()).implementationVersion(RuntimeVersionUtils.getVersion((Class)implementationClass)).platformType("Kubernetes").platformApiVersion(this.client.getApiVersion()).platformClientVersion(RuntimeVersionUtils.getVersion(this.client.getClass())).platformHostVersion("unknown").addPlatformSpecificInfo("master-url", String.valueOf(this.client.getMasterUrl())).addPlatformSpecificInfo("namespace", this.client.getNamespace()).build();
    }

    Map<String, String> createIdMap(String appId, AppDeploymentRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SPRING_APP_KEY, appId);
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (groupId != null) {
            map.put(SPRING_GROUP_KEY, groupId);
        }
        map.put(SPRING_DEPLOYMENT_KEY, appId);
        String appName = (String)request.getDeploymentProperties().get(APP_NAME_PROPERTY_KEY);
        if (StringUtils.hasText((String)appName)) {
            map.put(APP_NAME_KEY, appName);
        }
        return map;
    }

    protected AppStatus buildAppStatus(String id, PodList podList, ServiceList services) {
        AppStatus.Builder statusBuilder = AppStatus.of((String)id);
        Service service = null;
        if (podList != null && podList.getItems() != null) {
            block0: for (Pod pod : podList.getItems()) {
                String deploymentKey = (String)pod.getMetadata().getLabels().get(SPRING_DEPLOYMENT_KEY);
                for (Service svc : services.getItems()) {
                    if (!deploymentKey.startsWith(svc.getMetadata().getName())) continue;
                    service = svc;
                    break;
                }
                for (Container container : pod.getSpec().getContainers()) {
                    if (!container.getEnv().stream().anyMatch(envVar -> "SPRING_CLOUD_APPLICATION_GUID".equals(envVar.getName()))) continue;
                    Optional<ContainerStatus> containerStatusOptional = pod.getStatus().getContainerStatuses().stream().filter(containerStatus -> container.getName().equals(containerStatus.getName())).findFirst();
                    statusBuilder.with((AppInstanceStatus)new KubernetesAppInstanceStatus(pod, service, this.properties, containerStatusOptional.orElse(null)));
                    continue block0;
                }
            }
        }
        return statusBuilder.build();
    }

    protected void logPossibleDownloadResourceMessage(org.springframework.core.io.Resource resource) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Preparing to run a container from  " + resource + ". This may take some time if the image must be downloaded from a remote container registry."));
        }
    }

    PodSpec createPodSpec(AppDeploymentRequest appDeploymentRequest) {
        Container initContainer;
        Affinity affinity;
        PodSecurityContext podSecurityContext;
        Map<String, String> nodeSelectors;
        List<String> imagePullSecrets;
        String appId = this.createDeploymentId(appDeploymentRequest);
        Map deploymentProperties = appDeploymentRequest instanceof ScheduleRequest ? ((ScheduleRequest)appDeploymentRequest).getSchedulerProperties() : appDeploymentRequest.getDeploymentProperties();
        PodSpecBuilder podSpec = new PodSpecBuilder();
        String imagePullSecret = this.deploymentPropertiesResolver.getImagePullSecret(deploymentProperties);
        if (imagePullSecret != null) {
            podSpec.addNewImagePullSecret(imagePullSecret);
        }
        if ((imagePullSecrets = this.deploymentPropertiesResolver.getImagePullSecrets(deploymentProperties)) != null) {
            imagePullSecrets.forEach(imgPullsecret -> {
                PodSpecBuilder cfr_ignored_0 = (PodSpecBuilder)podSpec.addNewImagePullSecret(imgPullsecret);
            });
        }
        boolean hostNetwork = this.deploymentPropertiesResolver.getHostNetwork(deploymentProperties);
        ContainerConfiguration containerConfiguration = new ContainerConfiguration(appId, appDeploymentRequest).withProbeCredentialsSecret(this.getProbeCredentialsSecret(deploymentProperties)).withHostNetwork(hostNetwork);
        if (KubernetesAppDeployer.class.isAssignableFrom(this.getClass())) {
            containerConfiguration.withExternalPort(this.getExternalPort(appDeploymentRequest));
        }
        Container container = this.containerFactory.create(containerConfiguration);
        ResourceRequirements req = new ResourceRequirements();
        req.setLimits(this.deploymentPropertiesResolver.deduceResourceLimits(deploymentProperties));
        req.setRequests(this.deploymentPropertiesResolver.deduceResourceRequests(deploymentProperties));
        container.setResources(req);
        ImagePullPolicy pullPolicy = this.deploymentPropertiesResolver.deduceImagePullPolicy(deploymentProperties);
        container.setImagePullPolicy(pullPolicy.name());
        KubernetesDeployerProperties.Lifecycle lifecycle = this.deploymentPropertiesResolver.getLifeCycle(deploymentProperties);
        Lifecycle f8Lifecycle = new Lifecycle();
        if (lifecycle.getPostStart() != null) {
            f8Lifecycle.setPostStart(((HandlerBuilder)((HandlerFluent.ExecNested)new HandlerBuilder().withNewExec().addAllToCommand(lifecycle.getPostStart().getExec().getCommand())).and()).build());
        }
        if (lifecycle.getPreStop() != null) {
            f8Lifecycle.setPreStop(((HandlerBuilder)((HandlerFluent.ExecNested)new HandlerBuilder().withNewExec().addAllToCommand(lifecycle.getPreStop().getExec().getCommand())).and()).build());
        }
        if (f8Lifecycle.getPostStart() != null || f8Lifecycle.getPreStop() != null) {
            container.setLifecycle(f8Lifecycle);
        }
        if ((nodeSelectors = this.deploymentPropertiesResolver.getNodeSelectors(deploymentProperties)).size() > 0) {
            podSpec.withNodeSelector(nodeSelectors);
        }
        podSpec.withTolerations(this.deploymentPropertiesResolver.getTolerations(deploymentProperties));
        podSpec.withVolumes(this.deploymentPropertiesResolver.getVolumes(deploymentProperties).stream().filter(volume -> container.getVolumeMounts().stream().anyMatch(volumeMount -> volumeMount.getName().equals(volume.getName()))).collect(Collectors.toList()));
        if (hostNetwork) {
            podSpec.withHostNetwork(Boolean.valueOf(true));
        }
        podSpec.addToContainers(new Container[]{container});
        podSpec.withRestartPolicy(this.deploymentPropertiesResolver.getRestartPolicy(deploymentProperties).name());
        String deploymentServiceAcccountName = this.deploymentPropertiesResolver.getDeploymentServiceAccountName(deploymentProperties);
        if (deploymentServiceAcccountName != null) {
            podSpec.withServiceAccountName(deploymentServiceAcccountName);
        }
        if ((podSecurityContext = this.deploymentPropertiesResolver.getPodSecurityContext(deploymentProperties)) != null) {
            podSpec.withSecurityContext(podSecurityContext);
        }
        if ((affinity = this.deploymentPropertiesResolver.getAffinityRules(deploymentProperties)).getNodeAffinity() != null || affinity.getPodAffinity() != null || affinity.getPodAntiAffinity() != null) {
            podSpec.withAffinity(affinity);
        }
        if ((initContainer = this.deploymentPropertiesResolver.getInitContainer(deploymentProperties)) != null) {
            podSpec.addToInitContainers(new Container[]{initContainer});
        }
        podSpec.addAllToContainers(this.deploymentPropertiesResolver.getAdditionalContainers(deploymentProperties));
        return podSpec.build();
    }

    int getExternalPort(AppDeploymentRequest request) {
        int externalPort = 8080;
        Map parameters = request.getDefinition().getProperties();
        if (parameters.containsKey(SERVER_PORT_KEY)) {
            externalPort = Integer.valueOf((String)parameters.get(SERVER_PORT_KEY));
        }
        return externalPort;
    }

    String createDeploymentId(AppDeploymentRequest request) {
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = groupId == null ? String.format("%s", request.getDefinition().getName()) : String.format("%s-%s", groupId, request.getDefinition().getName());
        return deploymentId.replace('.', '-').toLowerCase();
    }

    Secret getProbeCredentialsSecret(Map<String, String> kubernetesDeployerProperties) {
        String secretName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.deploymentPropertiesResolver.getPropertyPrefix() + ".probeCredentialsSecret");
        if (!StringUtils.isEmpty((Object)secretName)) {
            return (Secret)((Resource)this.client.secrets().withName(secretName)).get();
        }
        return null;
    }
}

