/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.TcpProbeCreator;
import org.springframework.util.StringUtils;

class LivenessTcpProbeCreator
extends TcpProbeCreator {
    LivenessTcpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        String probeDelayValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.livenessTcpProbeDelay");
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessTcpProbeDelay();
    }

    @Override
    int getPeriod() {
        String probePeriodValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.livenessTcpProbePeriod");
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessTcpProbePeriod();
    }

    @Override
    Integer getPort() {
        String probePortValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.livenessTcpProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("LivenessTcpProbePort must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getLivenessTcpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getLivenessTcpProbePort();
        }
        throw new IllegalArgumentException("The livenessTcpProbePort property must be set.");
    }
}

