/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zafarkhaja.semver.Version;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

class KubernetesHttpClient {
    private static final Log logger = LogFactory.getLog(KubernetesHttpClient.class);
    private final OkHttpClient client;
    private final String masterUrl;

    KubernetesHttpClient(KubernetesClient client) {
        this.client = ((BaseClient)client).getHttpClient();
        this.masterUrl = this.getMasterUrl(client.getMasterUrl().toString());
    }

    private String getMasterUrl(String masterUrl) {
        return !masterUrl.endsWith("/") ? String.format("%s/", masterUrl) : masterUrl;
    }

    public Response post(String resourceEndpoint, String json) {
        String url = this.masterUrl + resourceEndpoint;
        logger.debug((Object)("Posting to " + url));
        Request post = new Request.Builder().post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json)).url(url).build();
        Response response = this.execute(this.client.newCall(post));
        response.close();
        return response;
    }

    public Response get(String resourceEndpoint, String appId) {
        String url = this.buildUrl(resourceEndpoint, appId);
        logger.debug((Object)("Getting " + url));
        Request get = new Request.Builder().get().url(url).build();
        return this.execute(this.client.newCall(get));
    }

    public Response delete(String resourceEndpoint, String appId) {
        String url = this.buildUrl(resourceEndpoint, appId);
        logger.debug((Object)("Deleting " + url));
        Request delete = new Request.Builder().delete().url(url).build();
        Response response = this.execute(this.client.newCall(delete));
        response.close();
        return response;
    }

    protected String buildUrl(String resourceEndpoint, String appId) {
        String url = this.masterUrl + resourceEndpoint;
        return StringUtils.hasText((String)appId) ? url + "/" + appId : url;
    }

    public static String getApiVersionForK8sVersionFromCluster(KubernetesHttpClient client) {
        try {
            Response response = client.get("version", "");
            Map versionResponse = (Map)new ObjectMapper().readValue(response.body().string(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
            return KubernetesHttpClient.getApiVersion((String)versionResponse.get("gitVersion"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception retrieving cluster version info. " + e.getMessage());
        }
    }

    public static String getApiVersion(String k8sVersionFromCluster) {
        Version version110 = Version.valueOf((String)"1.10.0");
        Pattern p = Pattern.compile("\\d+\\.\\d+\\.\\d");
        Matcher m = p.matcher(k8sVersionFromCluster);
        while (m.find()) {
            k8sVersionFromCluster = m.group();
        }
        return Version.valueOf((String)k8sVersionFromCluster).greaterThanOrEqualTo(version110) ? "v1" : "v1beta1";
    }

    private Response execute(Call call) {
        Response response;
        try {
            response = call.execute();
            logger.debug((Object)("Response code: " + response.code()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}

