/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesHttpClient;
import org.springframework.cloud.deployer.spi.kubernetes.PropertyParserUtils;
import org.springframework.util.StringUtils;

public class KubernetesAppDeployer
extends AbstractKubernetesDeployer
implements AppDeployer {
    private static final String SERVER_PORT_KEY = "server.port";
    private KubernetesHttpClient httpClient;
    private StatefulSetEndpoint statefulSetEndpoint = new StatefulSetEndpoint();
    private ObjectMapper objectMapper = new ObjectMapper();
    protected final Log logger = LogFactory.getLog((String)this.getClass().getName());

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        if (client != null) {
            this.httpClient = new KubernetesHttpClient(client);
            String apiVersion = KubernetesHttpClient.getApiVersionForK8sVersionFromCluster(this.httpClient);
            this.statefulSetEndpoint = new StatefulSetEndpoint(apiVersion, client.getNamespace());
        }
        this.containerFactory = containerFactory;
    }

    public String deploy(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        this.logger.debug((Object)String.format("Deploying app: %s", appId));
        try {
            boolean indexed;
            AppStatus status = this.status(appId);
            if (!status.getState().equals((Object)DeploymentState.unknown)) {
                throw new IllegalStateException(String.format("App '%s' is already deployed", appId));
            }
            int externalPort = this.configureExternalPort(request);
            String indexedProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.indexed");
            boolean bl = indexed = indexedProperty != null ? Boolean.valueOf(indexedProperty) : false;
            if (indexed) {
                Map<String, String> idMap = this.createIdMap(appId, request);
                this.logger.debug((Object)String.format("Creating Service: %s on %d with", appId, externalPort));
                this.createService(appId, request, idMap, externalPort);
                String statefulSetJson = this.createStatefulSet(appId, request, idMap, externalPort);
                Response response = this.httpClient.post(this.statefulSetEndpoint.getEndpoint(), statefulSetJson);
                if (!response.isSuccessful()) {
                    throw new RuntimeException(String.format("Create StatefulSet failed. response code %d, message %s", response.code(), response.message()));
                }
            } else {
                Map<String, String> idMap = this.createIdMap(appId, request);
                this.logger.debug((Object)String.format("Creating Service: %s on {}", appId, externalPort));
                this.createService(appId, request, idMap, externalPort);
                this.logger.debug((Object)String.format("Creating Deployment: %s", appId));
                this.createDeployment(appId, request, idMap, externalPort);
            }
            return appId;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void undeploy(String appId) {
        this.logger.debug((Object)String.format("Undeploying app: %s", appId));
        AppStatus status = this.status(appId);
        if (status.getState().equals((Object)DeploymentState.unknown)) {
            throw new IllegalStateException(String.format("App '%s' is not deployed", appId));
        }
        List apps = ((ServiceList)((FilterWatchListDeletable)this.client.services().withLabel("spring-app-id", appId)).list()).getItems();
        if (apps != null) {
            for (Service app : apps) {
                String appIdToDelete = app.getMetadata().getName();
                this.logger.debug((Object)String.format("Deleting Resources for: %s", appIdToDelete));
                Service svc = (Service)((Resource)this.client.services().withName(appIdToDelete)).get();
                try {
                    FilterWatchListDeletable pvcsToDelete;
                    Response response;
                    Boolean statefulSetDeleted;
                    Boolean deplDeleted;
                    if (svc != null && "LoadBalancer".equals(svc.getSpec().getType())) {
                        int tries = 0;
                        int maxWait = this.properties.getMinutesToWaitForLoadBalancer() * 6;
                        while (tries++ < maxWait && svc.getStatus() != null && svc.getStatus().getLoadBalancer() != null && svc.getStatus().getLoadBalancer().getIngress() != null && svc.getStatus().getLoadBalancer().getIngress().isEmpty()) {
                            if (tries % 6 == 0) {
                                this.logger.warn((Object)"Waiting for LoadBalancer to complete before deleting it ...");
                            }
                            this.logger.debug((Object)String.format("Waiting for LoadBalancer, try %d", tries));
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            svc = (Service)((Resource)this.client.services().withName(appIdToDelete)).get();
                        }
                        this.logger.debug((Object)String.format("LoadBalancer Ingress: %s", svc.getStatus().getLoadBalancer().getIngress().toString()));
                    }
                    Boolean svcDeleted = (Boolean)((Resource)this.client.services().withName(appIdToDelete)).delete();
                    this.logger.debug((Object)String.format("Deleted Service for: %s %b", appIdToDelete, svcDeleted));
                    Boolean rcDeleted = (Boolean)((RollableScalableResource)this.client.replicationControllers().withName(appIdToDelete)).delete();
                    if (rcDeleted.booleanValue()) {
                        this.logger.debug((Object)String.format("Deleted Replication Controller for: %s %b", appIdToDelete, rcDeleted));
                    }
                    if ((deplDeleted = (Boolean)((ScalableResource)this.client.extensions().deployments().withName(appIdToDelete)).delete()).booleanValue()) {
                        this.logger.debug((Object)String.format("Deleted Deployment for: %s %b", appIdToDelete, deplDeleted));
                    }
                    if ((statefulSetDeleted = Boolean.valueOf((response = this.httpClient.delete(this.statefulSetEndpoint.getEndpoint(), appIdToDelete)).isSuccessful())).booleanValue()) {
                        this.logger.debug((Object)String.format("Deleted StatefulSet for: %s %b", appIdToDelete, statefulSetDeleted));
                    }
                    HashMap<String, String> selector = new HashMap<String, String>();
                    selector.put("spring-app-id", appIdToDelete);
                    FilterWatchListDeletable podsToDelete = (FilterWatchListDeletable)this.client.pods().withLabels(selector);
                    if (podsToDelete != null && ((PodList)podsToDelete.list()).getItems() != null) {
                        Boolean podDeleted = (Boolean)podsToDelete.delete();
                        this.logger.debug((Object)String.format("Deleted Pods for: %s %b", appIdToDelete, podDeleted));
                    } else {
                        this.logger.debug((Object)String.format("No Pods to delete for: %s", appIdToDelete));
                    }
                    if ((pvcsToDelete = (FilterWatchListDeletable)this.client.persistentVolumeClaims().withLabels(selector)) == null || ((PersistentVolumeClaimList)pvcsToDelete.list()).getItems() == null) continue;
                    Boolean pvcDeleted = (Boolean)pvcsToDelete.delete();
                    if (pvcDeleted.booleanValue()) {
                        this.logger.debug((Object)String.format("Deleted pvcs for: %s %b", appIdToDelete, pvcDeleted));
                        continue;
                    }
                    this.logger.debug((Object)String.format("No pvcs to delete for: %s", appIdToDelete));
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public AppStatus status(String appId) {
        HashMap<String, String> selector = new HashMap<String, String>();
        ServiceList services = (ServiceList)((FilterWatchListDeletable)this.client.services().withLabel("spring-app-id", appId)).list();
        selector.put("spring-app-id", appId);
        PodList podList = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Building AppStatus for app: %s", appId));
            if (podList != null && podList.getItems() != null) {
                this.logger.debug((Object)String.format("Pods for appId %s: %d", appId, podList.getItems().size()));
                for (Pod pod : podList.getItems()) {
                    this.logger.debug((Object)String.format("Pod: %s", pod.getMetadata().getName()));
                }
            }
        }
        AppStatus status = this.buildAppStatus(appId, podList, services);
        this.logger.debug((Object)String.format("Status for app: %s is %s", appId, status));
        return status;
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(AppDeployer.class, this.getClass());
    }

    protected int configureExternalPort(AppDeploymentRequest request) {
        int externalPort = 8080;
        Map parameters = request.getDefinition().getProperties();
        if (parameters.containsKey(SERVER_PORT_KEY)) {
            externalPort = Integer.valueOf((String)parameters.get(SERVER_PORT_KEY));
        }
        return externalPort;
    }

    protected String createDeploymentId(AppDeploymentRequest request) {
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = groupId == null ? String.format("%s", request.getDefinition().getName()) : String.format("%s-%s", groupId, request.getDefinition().getName());
        return deploymentId.replace('.', '-').toLowerCase();
    }

    private Deployment createDeployment(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        int replicas = this.getCountFromRequest(request);
        Map<String, String> annotations = this.getPodAnnotations(request);
        Deployment d = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(replicas))).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).withAnnotations(annotations)).endMetadata()).withSpec(this.createPodSpec(appId, request, externalPort, false))).endTemplate()).endSpec()).build();
        return (Deployment)this.client.extensions().deployments().create((Object[])new Deployment[]{d});
    }

    private int getCountFromRequest(AppDeploymentRequest request) {
        String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
        return countProperty != null ? Integer.parseInt(countProperty) : 1;
    }

    protected String createStatefulSet(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        int replicas = this.getCountFromRequest(request);
        this.logger.debug((Object)String.format("Creating StatefulSet: %s on %d with %d replicas", appId, externalPort, replicas));
        Map<String, Quantity> storageResource = Collections.singletonMap("storage", new Quantity(this.getStatefulSetStorage(request)));
        String storageClassName = this.getStatefulSetStorageClassName(request);
        PersistentVolumeClaimBuilder persistentVolumeClaimBuilder = (PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)new PersistentVolumeClaimBuilder().withNewSpec().withStorageClassName(storageClassName)).withAccessModes(Arrays.asList("ReadWriteOnce"))).withNewResources().addToLimits(storageResource)).addToRequests(storageResource)).endResources()).endSpec()).withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata();
        PodSpec podSpec = this.createPodSpec(appId, request, externalPort, false);
        podSpec.getVolumes().add(((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("config")).withNewEmptyDir().endEmptyDir()).build());
        ((Container)podSpec.getContainers().get(0)).getVolumeMounts().add(((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("config")).withMountPath("/config")).build());
        podSpec.getInitContainers().add(this.createInitContainer());
        StatefulSetSpec spec = ((StatefulSetSpecBuilder)((StatefulSetSpecFluent.TemplateNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecFluent.SelectorNested)((StatefulSetSpecFluent.SelectorNested)new StatefulSetSpecBuilder().withNewSelector().addToMatchLabels(idMap)).addToMatchLabels("role", "spring-app")).endSelector()).withVolumeClaimTemplates(new PersistentVolumeClaim[]{persistentVolumeClaimBuilder.build()})).withServiceName(appId)).withReplicas(Integer.valueOf(replicas))).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(podSpec)).endTemplate()).build();
        StatefulSet statefulSet = ((StatefulSetBuilder)((StatefulSetBuilder)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withApiVersion(this.statefulSetEndpoint.getVersion())).withSpec(spec)).build();
        Map statefulSetMap = null;
        try {
            String ssString = this.objectMapper.writeValueAsString((Object)statefulSet);
            statefulSetMap = (Map)this.objectMapper.readValue(ssString, HashMap.class);
        }
        catch (JsonProcessingException e) {
            this.logger.error((Object)"Could not create StatefulSet.", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not create StatefulSet.", (Throwable)e);
        }
        Map specMap = (Map)statefulSetMap.get("spec");
        specMap.put("podManagementPolicy", "Parallel");
        try {
            return this.objectMapper.writeValueAsString((Object)statefulSetMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void createService(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        ServiceSpecBuilder spec = new ServiceSpecBuilder();
        boolean isCreateLoadBalancer = false;
        String createLoadBalancer = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createLoadBalancer");
        String createNodePort = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createNodePort");
        if (createLoadBalancer != null && createNodePort != null) {
            throw new IllegalArgumentException("Cannot create NodePort and LoadBalancer at the same time.");
        }
        if (createLoadBalancer == null) {
            isCreateLoadBalancer = this.properties.isCreateLoadBalancer();
        } else if ("true".equals(createLoadBalancer.toLowerCase())) {
            isCreateLoadBalancer = true;
        }
        if (isCreateLoadBalancer) {
            spec.withType("LoadBalancer");
        }
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(externalPort));
        if (createNodePort != null) {
            spec.withType("NodePort");
            if (!"true".equals(createNodePort.toLowerCase())) {
                try {
                    Integer nodePort = Integer.valueOf(createNodePort);
                    servicePort.setNodePort(nodePort);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid value: %s: provided port is not valid.", createNodePort));
                }
            }
        }
        ((ServiceSpecBuilder)spec.withSelector(idMap)).addNewPortLike(servicePort).endPort();
        Map<String, String> annotations = this.getServiceAnnotations(request);
        ((DoneableService)((DoneableService)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((DoneableService)((NonNamespaceOperation)this.client.services().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).withLabels(idMap)).withAnnotations(annotations)).addToLabels("role", "spring-app")).endMetadata()).withSpec(spec.build())).done();
    }

    private Map<String, String> getPodAnnotations(AppDeploymentRequest request) {
        String annotationsProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.podAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsProperty)) {
            annotationsProperty = this.properties.getPodAnnotations();
        }
        return PropertyParserUtils.getAnnotations(annotationsProperty);
    }

    private Map<String, String> getServiceAnnotations(AppDeploymentRequest request) {
        String annotationsProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.serviceAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsProperty)) {
            annotationsProperty = this.properties.getServiceAnnotations();
        }
        return PropertyParserUtils.getAnnotations(annotationsProperty);
    }

    private Container createInitContainer() {
        LinkedList<String> command = new LinkedList<String>();
        String commandString = String.format("%s && %s", this.setIndexProperty("INSTANCE_INDEX"), this.setIndexProperty("spring.application.index"));
        command.add("sh");
        command.add("-c");
        command.add(commandString);
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("index-provider")).withImage("busybox")).withImagePullPolicy("IfNotPresent")).withCommand(command)).withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("config")).withMountPath("/config")).build()})).build();
    }

    private String setIndexProperty(String name) {
        return String.format("echo %s=\"$(expr $HOSTNAME | grep -o \"[[:digit:]]*$\")\" >> /config/application.properties", name);
    }

    private static class StatefulSetEndpoint {
        private String namespace = "default";
        private String apiVersion = "v1beta1";

        public StatefulSetEndpoint() {
        }

        public StatefulSetEndpoint(String apiVersion, String namespace) {
            this.apiVersion = apiVersion;
            this.namespace = namespace;
        }

        public String getVersion() {
            return "apps/" + this.apiVersion;
        }

        public String getEndpoint() {
            return String.format("apis/%s/namespaces/%s/statefulsets", this.getVersion(), this.namespace);
        }
    }
}

