/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.extensions.DoneableJob;
import io.fabric8.kubernetes.api.model.extensions.EditableJobSpec;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.JobSpec;
import io.fabric8.kubernetes.api.model.extensions.JobSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;

public class KubernetesTaskLauncher
extends AbstractKubernetesDeployer
implements TaskLauncher {
    private KubernetesDeployerProperties properties = new KubernetesDeployerProperties();
    private final KubernetesClient client;
    private final ContainerFactory containerFactory;
    private final Map<String, Object> running = new ConcurrentHashMap<String, Object>();

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        this.containerFactory = containerFactory;
    }

    public String launch(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        TaskStatus status = this.status(appId);
        if (!status.getState().equals((Object)LaunchState.unknown)) {
            if (status.getState().equals((Object)LaunchState.launching) || status.getState().equals((Object)LaunchState.running)) {
                throw new IllegalStateException("Task " + appId + " is already active with a state of " + status);
            }
            this.deleteJob(appId);
        }
        Map<String, String> idMap = this.createIdMap(appId, request);
        logger.debug("Launching job: {}", (Object)appId);
        try {
            this.createJob(appId, request, idMap);
            return appId;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void cancel(String id) {
        logger.debug("Cancelling job: {}", (Object)id);
        this.delete(id);
    }

    public void delete(String id) {
        logger.debug("Deleting job: {}", (Object)id);
        this.deleteJob(id);
    }

    public TaskStatus status(String id) {
        HashMap<String, String> selector = new HashMap<String, String>();
        selector.put("spring-app-id", id);
        PodList list = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
        TaskStatus status = this.buildTaskStatus(this.properties, id, list);
        logger.debug("Status for task: {} is {}", (Object)id, (Object)status);
        return status;
    }

    private Container createContainer(String appId, AppDeploymentRequest request) {
        Container container = this.containerFactory.create(appId, request, null);
        ResourceRequirements req = new ResourceRequirements();
        req.setLimits(this.deduceResourceLimits(this.properties, request));
        container.setResources(req);
        return container;
    }

    private PodSpec createPodSpec(String appId, AppDeploymentRequest request) {
        PodSpecBuilder podSpec = new PodSpecBuilder();
        if (this.properties.getImagePullSecret() != null) {
            podSpec.addNewImagePullSecret(this.properties.getImagePullSecret());
        }
        podSpec.addToContainers(new Container[]{this.createContainer(appId, request)});
        podSpec.withRestartPolicy("Never");
        return podSpec.build();
    }

    private void createJob(String appId, AppDeploymentRequest request, Map<String, String> idMap) {
        HashMap<String, String> jobLabelMap = new HashMap<String, String>();
        jobLabelMap.put("job-name", appId);
        jobLabelMap.put("role", "spring-app");
        EditableJobSpec spec = ((JobSpecBuilder)new JobSpecBuilder().withTemplate(new PodTemplateSpec((ObjectMeta)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withLabels(jobLabelMap)).addToLabels(idMap)).build(), this.createPodSpec(appId, request)))).build();
        ((DoneableJob)((DoneableJob)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((DoneableJob)((ClientNonNamespaceOperation)this.client.extensions().jobs().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).withLabels(jobLabelMap)).addToLabels(idMap)).endMetadata()).withSpec((JobSpec)spec)).done();
    }

    private void deleteJob(String id) {
        try {
            Boolean jobDeleted = (Boolean)((ClientResource)((ClientNonNamespaceOperation)this.client.extensions().jobs().inNamespace(this.client.getNamespace())).withName(id)).delete();
            if (jobDeleted.booleanValue()) {
                logger.debug("Deleted job successfully: {}", (Object)id);
            } else {
                logger.debug("Delete failed for job: {}", (Object)id);
            }
            HashMap<String, String> selector = new HashMap<String, String>();
            selector.put("spring-app-id", id);
            PodList list = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
            for (Pod p : list.getItems()) {
                logger.debug("Deleting pod: {}", (Object)p.getMetadata().getName());
                ((ClientPodResource)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).withName(p.getMetadata().getName())).delete();
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    TaskStatus buildTaskStatus(KubernetesDeployerProperties properties, String id, PodList list) {
        Job job = (Job)((ClientResource)((ClientNonNamespaceOperation)this.client.extensions().jobs().inNamespace(this.client.getNamespace())).withName(id)).get();
        if (job == null) {
            return new TaskStatus(id, LaunchState.unknown, new HashMap());
        }
        JobStatus jobStatus = job.getStatus();
        if (jobStatus == null) {
            return new TaskStatus(id, LaunchState.unknown, new HashMap());
        }
        if (jobStatus.getActive() != null) {
            if (jobStatus.getActive() > 0) {
                return new TaskStatus(id, LaunchState.running, new HashMap());
            }
            return new TaskStatus(id, LaunchState.launching, new HashMap());
        }
        if (list == null || list.getItems().isEmpty()) {
            return new TaskStatus(id, LaunchState.launching, new HashMap());
        }
        if (jobStatus.getSucceeded().intValue() == list.getItems().size()) {
            return new TaskStatus(id, LaunchState.complete, new HashMap());
        }
        return new TaskStatus(id, LaunchState.failed, new HashMap());
    }
}

